#!/bin/bash
clear

tput setaf 5
echo -e "\n \n*******************************************************************************************************************"
echo -e "Instalowanie Falco..."
echo -e "\nW trakcie wykonywania skryptu możesz zobaczyć pytanie o hasło dla sudo"
echo -e "*******************************************************************************************************************"

tput setaf 5
echo -e "\n \n*******************************************************************************************************************"
echo -e "Instalowanie pełnego pakietu Go - niezbędny do utworzenia pliku exe driverkit"
echo -e "*******************************************************************************************************************"
tput setaf 2
sudo add-apt-repository ppa:longsleep/golang-backports -y
sudo apt-update -y
sudo apt install golang-go -y

tput setaf 5
echo -e "\n \n*******************************************************************************************************************"
echo -e "Pobieranie obrazu driverkit-builder"
echo -e "*******************************************************************************************************************"
tput setaf 2
docker pull falcosecurity/driverkit-builder

tput setaf 5
echo -e "\n \n*******************************************************************************************************************"
echo -e "Pobieranie i kompilowanie pliku wykonywalnego driverkit"
echo -e "*******************************************************************************************************************"
tput setaf 2
GO111MODULE="on" go get github.com/falcosecurity/driverkit

tput setaf 5
kernelversion=$(uname -v | cut -f1 -d'-' | cut -f2 -d'#')
kernelrelease=$(uname -r)
echo -e "\n \n*******************************************************************************************************************"
echo -e "Utworzenie sondy Falco na podstawie systemu operacyjnego hosta"
tput setaf 7
echo -e "Wersja jądra: $kernelversion"
echo -e "Wydanie jądra: $kernelrelease"
tput setaf 5
echo -e "*******************************************************************************************************************"
tput setaf 2
driverkit docker --output-module /tmp/falco.ko --kernelversion=$kernelversion --kernelrelease=$kernelrelease --driverversion=dev --target=ubuntu-generic

tput setaf 6
echo -e "\n \n*******************************************************************************************************************"
echo -e "Kopiowanie modułu Falco do modules/kernelrelease/ i dodawanie do hosta"
echo -e "*******************************************************************************************************************"
tput setaf 2
sudo cp /tmp/falco.ko /lib/modules/$kernelrelease/falco.ko
sudo depmod
sudo modprobe falco

tput setaf 7
echo -e "\n \n*******************************************************************************************************************"
echo -e "Ponieważ Docker wczytuje system plików jedynie podczas uruchamiania, konieczne jest ponowne uruchomienie Dockera, aby KinD dostrzegł nowe Falco"
echo -e" modules in /dev"
echo -e "\nRestarting Docker..."
echo -e "*******************************************************************************************************************"

tput setaf 6
echo -e "\n \n*******************************************************************************************************************"
echo -e "Utworzenie przestrzeni nazw Falco"
echo -e "*******************************************************************************************************************"
tput setaf 2
kubectl create ns falco


tput setaf 6
echo -e "\n \n*******************************************************************************************************************"
echo -e "Wdrażanie w klastrze manifestów Falco"
echo -e "*******************************************************************************************************************"
tput setaf 2
kubectl create configmap falco-config --from-file=falco/falco-config -n falco
kubectl apply -f falco/install -n falco

tput setaf 3
echo -e "\n \n*******************************************************************************************************************"
echo -e "Zakończenie wdrażania Falco - weryfikacja utworzenia poda Falco w przestrzeni nazw Falco i potwierdzenie jego działania"
echo -e "*******************************************************************************************************************"
tput setaf 2

echo -e "\n\n"
