package ch02.ex3_6_2_IfToWhen1

interface Expr
class Num(val value: Int) : Expr
class Sum(val left: Expr, val right: Expr) : Expr

fun eval(e: Expr): Int =
    when (e) {
        is Num ->
            e.value
        is Sum ->
            eval(e.right) + eval(e.left)
        else ->
            throw IllegalArgumentException("Nieznane wyrażenie")
    }

fun main(args: Array<String>) {
    println(eval(Sum(Num(1), Num(2))))
}
