<?php
include(__DIR__.'/Omega/PwmExp.php');

$frequency = 50; # częstotliwość
$channel = 15;   # numer kanału, wartość -1 oznacza wszystkie kanały
$duty = 3.5;     # wypełnienie
$delay = 0;      # opóźnienie
$steps = 3;      # liczba kroków dla obrotu o 180 stopni

$pwm = new \Omega\PwmExp($initialize = true);

if ($pwm->isInitialized())
{
  $pwm->setFrequency($frequency);
  
  # generowanie sygnału PWM
  # obrót serwomechanizmu w jedną stronę
  for ($i = 1; $i <= $steps; $i++) {
    $duty = $duty + (11 / $steps);
    $pwm->setupDriver($channel, $duty, $delay);
    usleep(200000);
  }
  # i w drugą stronę
  for ($i = 1; $i <= $steps; $i++) {
    $duty = $duty - (11 / $steps);
    $pwm->setupDriver($channel, $duty, $delay);
    usleep(200000);
  }
  
  # odczekaj chwilkę
  sleep(1);
  
  # wyłącz oscylator
  $pwm->disableChip();
}