#include <stdio.h>
#include "pwm-exp.h"

int main()
{
  int channel = 15; // numer kanału, wartość -1 oznacza wszystkie kanały
  float duty = 3.5; // wypełnienie
  float delay = 0;  // opóźnienie
  int steps = 4;    // liczba kroków dla obrotu o 180 stopni	
  int status, init, i;
  
  pwmDriverInit();
  
  status = pwmCheckInit(&init);
  if (init == 0) {
    printf("Moduł Servo (PWM) Expansion nie jest zainicjowany.\n");
    exit;
  }  
  
  float frequency = 50; // częstotliwość
  pwmSetFrequency (frequency);  
  
  // generowanie sygnału PWM
  // obrót serwomechanizmu w jedną stronę
  for (i = 1; i <= steps; i++) {
    duty = duty + (11 / steps);
    pwmSetupDriver(channel, duty, delay);
    usleep(200000);
  }
  // i w drugą stronę
  for (i = 1; i <= steps; i++) {
    duty = duty - (11 / steps);
    pwmSetupDriver(channel, duty, delay);
    usleep(200000);
  }

  sleep(1); // odczekaj chwilkę
  
  pwmDisableChip(); // wyłącz oscylator
  
  return(0);
}