import time

# import modułu PWM
from OmegaExpansion import pwmExp

# zainicjuj rozszerzenie Servo (PWM)
pwmExp.driverInit()

# sprawdź czy inicjacja jest pomyślna
status = pwmExp.checkInit()
if (status == 0):    
    exit()

frequency = 50 # częstotliwość
pwmExp.setFrequency(frequency)

channel = 15 # numer kanału, wartość -1 oznacza wszystkie kanały
duty = 3.5   # wypełnienie
delay = 0    # opóźnienie

steps = 5;   # liczba kroków dla obrotu o 180 stopni

# generowanie sygnału PWM
# obrót serwomechanizmu w jedną stronę
for i in range(1, steps):
    duty = duty + (11 / steps)
    pwmExp.setupDriver(channel, duty, delay)
    time.sleep(0.2)
# i w drugą stronę
for i in range(1, steps):
    duty = duty - (11 / steps)
    pwmExp.setupDriver(channel, duty, delay)
    time.sleep(0.2)

# odczekaj chwilkę
time.sleep(0.5)

# wyłącz oscylator
pwmExp.disableChip()