package com.shapira.examples.streams.stockstats.model;

public class TradeStats {

    String type;
    String ticker;
    int countTrades; // Śledzimy liczbę i sumę, byśmy mogli obliczyć później średnią cenę
    double sumPrice;
    double minPrice;
    double avgPrice;

    public TradeStats add(Trade trade) {

        if (trade.type == null || trade.ticker == null)
            throw new IllegalArgumentException("Niewłaściwa transakcja do zagregowania: " + trade.toString());

        if (this.type == null)
            this.type = trade.type;
        if (this.ticker == null)
            this.ticker = trade.ticker;

        if (!this.type.equals(trade.type) || !this.ticker.equals(trade.ticker))
            throw new IllegalArgumentException("Agregowanie statystyk dla transakcji typu" + this.type + " i symbolu spółki " + this.ticker + ", ale otrzymano transakcję typu " + trade.type +" i symbol spółki " + trade.ticker );

        if (countTrades == 0) this.minPrice = trade.price;
        
        this.countTrades = this.countTrades+1;
        this.sumPrice = this.sumPrice + trade.price;
        this.minPrice = this.minPrice < trade.price ? this.minPrice : trade.price;

        return this;
    }

    public TradeStats computeAvgPrice() {
        this.avgPrice = this.sumPrice / this.countTrades;
        return this;
    }
}
