/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.util;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OsgiUtils {
    private static final Logger LOG = LoggerFactory.getLogger(OsgiUtils.class);

    public static Set<String> getAllBundleExports(FileFilter filter, Set<String> pkgs) {
        if (pkgs == null) {
            pkgs = new HashSet<String>();
        }
        Set<File> candidates = OsgiUtils.getClasspathCandidates(filter);
        for (File candidate : candidates) {
            String exports = OsgiUtils.getBundleExports(candidate);
            if (exports == null) {
                LOG.debug("No export found for candidate: {}", (Object)candidate);
                continue;
            }
            LOG.debug("Processing exports for candidate: {}\n\n{}\n", (Object)candidate, (Object)exports);
            OsgiUtils.splitIntoPackages(exports, pkgs);
        }
        return pkgs;
    }

    public static Set<String> splitIntoPackages(String exports, Set<String> pkgs) {
        if (pkgs == null) {
            pkgs = new HashSet<String>();
        }
        int index = 0;
        boolean inPkg = true;
        boolean inProps = false;
        StringBuilder pkg = new StringBuilder();
        while (index < exports.length()) {
            if (inPkg && exports.charAt(index) != ';') {
                pkg.append(exports.charAt(index));
                ++index;
                continue;
            }
            if (inPkg && exports.charAt(index) == ';') {
                inPkg = false;
                inProps = true;
                pkgs.add(pkg.toString());
                LOG.debug("Added package: {}", (Object)pkg.toString());
                pkg.setLength(0);
                index += 8;
                continue;
            }
            if (inProps && exports.charAt(index) == '\"' && index + 1 < exports.length() && exports.charAt(index + 1) == ',') {
                inPkg = true;
                inProps = false;
                index += 2;
                continue;
            }
            if (inProps) {
                ++index;
                continue;
            }
            LOG.error("Unexpected parser condition throwing IllegalStateException.");
            throw new IllegalStateException("Should never get here!");
        }
        return pkgs;
    }

    public static Set<File> getClasspathCandidates(FileFilter filter) {
        String[] cpElements;
        HashSet<File> candidates = new HashSet<File>();
        String separator = System.getProperty("path.separator");
        for (String element : cpElements = System.getProperty("java.class.path").split(separator)) {
            File candidate = new File(element);
            if (!candidate.isFile()) continue;
            if (filter != null && filter.accept(candidate)) {
                candidates.add(candidate);
                LOG.info("Accepted candidate with filter: {}", (Object)candidate.toString());
                continue;
            }
            if (filter == null && candidate.getName().endsWith(".jar")) {
                candidates.add(candidate);
                LOG.info("Accepted candidate without filter: {}", (Object)candidate.toString());
                continue;
            }
            LOG.info("Rejecting candidate: {}", (Object)candidate.toString());
        }
        return candidates;
    }

    public static String getBundleExports(File bundle) {
        try {
            JarFile jar = new JarFile(bundle);
            Manifest manifest = jar.getManifest();
            if (manifest == null) {
                return null;
            }
            for (Map.Entry<Object, Object> attr : manifest.getMainAttributes().entrySet()) {
                if (!attr.getKey().toString().equals("Export-Package")) continue;
                return attr.getValue().toString();
            }
            return null;
        }
        catch (IOException e) {
            LOG.error("Failed to open jar file or manifest.", e);
            throw new RuntimeException("Failed to open jar file or manifest.", e);
        }
    }
}

