/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.common;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import org.slf4j.Logger;

public class IOUtils {
    public static void closeStream(Closeable stream) {
        IOUtils.cleanup(null, stream);
    }

    public static void cleanup(Logger log, Closeable ... closeables) {
        for (Closeable c : closeables) {
            if (c == null) continue;
            try {
                c.close();
            }
            catch (IOException e) {
                if (log == null) continue;
                log.warn("Exception in closing " + c, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyBytes(InputStream in, OutputStream out, int buffSize, boolean close) throws IOException {
        try {
            IOUtils.copyBytes(in, out, buffSize);
            if (close) {
                out.close();
                out = null;
                in.close();
                in = null;
            }
            Object var5_4 = null;
            if (!close) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!close) throw throwable;
            IOUtils.closeStream(out);
            IOUtils.closeStream(in);
            throw throwable;
        }
        IOUtils.closeStream(out);
        IOUtils.closeStream(in);
    }

    public static void copyBytes(InputStream in, OutputStream out, int buffSize) throws IOException {
        PrintStream ps = out instanceof PrintStream ? (PrintStream)out : null;
        byte[] buf = new byte[buffSize];
        int bytesRead = in.read(buf);
        while (bytesRead >= 0) {
            out.write(buf, 0, bytesRead);
            if (ps != null && ps.checkError()) {
                throw new IOException("Unable to write to output stream.");
            }
            bytesRead = in.read(buf);
        }
    }
}

