/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.v2.app;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.v2.api.records.JobReport;
import org.mortbay.log.Log;

public class JobEndNotifier
implements Configurable {
    private static final String JOB_ID = "$jobId";
    private static final String JOB_STATUS = "$jobStatus";
    private Configuration conf;
    protected String userUrl;
    protected String proxyConf;
    protected int numTries;
    protected int waitInterval;
    protected int timeout;
    protected URL urlToNotify;
    protected Proxy proxyToUse = Proxy.NO_PROXY;

    @Override
    public void setConf(Configuration conf) {
        this.conf = conf;
        this.numTries = Math.min(conf.getInt("mapreduce.job.end-notification.retry.attempts", 0) + 1, conf.getInt("mapreduce.job.end-notification.max.attempts", 1));
        this.waitInterval = Math.min(conf.getInt("mapreduce.job.end-notification.retry.interval", 5000), conf.getInt("mapreduce.job.end-notification.max.retry.interval", 5000));
        this.waitInterval = this.waitInterval < 0 ? 5000 : this.waitInterval;
        this.timeout = conf.getInt("mapreduce.job.end-notification.timeout", 5000);
        this.userUrl = conf.get("mapreduce.job.end-notification.url");
        this.proxyConf = conf.get("mapreduce.job.end-notification.proxy");
        if (this.proxyConf != null && !this.proxyConf.equals("") && this.proxyConf.lastIndexOf(":") != -1) {
            int typeIndex = this.proxyConf.indexOf("@");
            Proxy.Type proxyType = Proxy.Type.HTTP;
            if (typeIndex != -1 && this.proxyConf.substring(0, typeIndex).compareToIgnoreCase("socks") == 0) {
                proxyType = Proxy.Type.SOCKS;
            }
            String hostname = this.proxyConf.substring(typeIndex + 1, this.proxyConf.lastIndexOf(":"));
            String portConf = this.proxyConf.substring(this.proxyConf.lastIndexOf(":") + 1);
            try {
                int port = Integer.parseInt(portConf);
                this.proxyToUse = new Proxy(proxyType, new InetSocketAddress(hostname, port));
                Log.info("Job end notification using proxy type \"" + (Object)((Object)proxyType) + "\" hostname \"" + hostname + "\" and port \"" + port + "\"");
            }
            catch (NumberFormatException nfe) {
                Log.warn("Job end notification couldn't parse configured proxy's port " + portConf + ". Not going to use a proxy");
            }
        }
    }

    @Override
    public Configuration getConf() {
        return this.conf;
    }

    protected boolean notifyURLOnce() {
        boolean success = false;
        try {
            Log.info("Job end notification trying " + this.urlToNotify);
            HttpURLConnection conn = (HttpURLConnection)this.urlToNotify.openConnection(this.proxyToUse);
            conn.setConnectTimeout(this.timeout);
            conn.setReadTimeout(this.timeout);
            conn.setAllowUserInteraction(false);
            if (conn.getResponseCode() != 200) {
                Log.warn("Job end notification to " + this.urlToNotify + " failed with code: " + conn.getResponseCode() + " and message \"" + conn.getResponseMessage() + "\"");
            } else {
                success = true;
                Log.info("Job end notification to " + this.urlToNotify + " succeeded");
            }
        }
        catch (IOException ioe) {
            Log.warn("Job end notification to " + this.urlToNotify + " failed", ioe);
        }
        return success;
    }

    public void notify(JobReport jobReport) throws InterruptedException {
        if (this.userUrl == null) {
            Log.info("Job end notification URL not set, skipping.");
            return;
        }
        if (this.userUrl.contains(JOB_ID)) {
            this.userUrl = this.userUrl.replace(JOB_ID, jobReport.getJobId().toString());
        }
        if (this.userUrl.contains(JOB_STATUS)) {
            this.userUrl = this.userUrl.replace(JOB_STATUS, jobReport.getJobState().toString());
        }
        try {
            this.urlToNotify = new URL(this.userUrl);
        }
        catch (MalformedURLException mue) {
            Log.warn("Job end notification couldn't parse " + this.userUrl, mue);
            return;
        }
        boolean success = false;
        while (this.numTries-- > 0 && !success) {
            Log.info("Job end notification attempts left " + this.numTries);
            success = this.notifyURLOnce();
            if (success) continue;
            Thread.sleep(this.waitInterval);
        }
        if (!success) {
            Log.warn("Job end notification failed to notify : " + this.urlToNotify);
        } else {
            Log.info("Job end notification succeeded for " + jobReport.getJobId());
        }
    }
}

