/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.protocolPB;

import com.google.common.base.Optional;
import com.google.common.primitives.Longs;
import com.google.protobuf.ByteString;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.ReconfigurationTaskStatus;
import org.apache.hadoop.conf.ReconfigurationUtil;
import org.apache.hadoop.hdfs.client.BlockReportOptions;
import org.apache.hadoop.hdfs.protocol.BlockLocalPathInfo;
import org.apache.hadoop.hdfs.protocol.ClientDatanodeProtocol;
import org.apache.hadoop.hdfs.protocol.HdfsBlocksMetadata;
import org.apache.hadoop.hdfs.protocol.proto.ClientDatanodeProtocolProtos;
import org.apache.hadoop.hdfs.protocolPB.ClientDatanodeProtocolPB;
import org.apache.hadoop.hdfs.protocolPB.PBHelper;
import org.apache.hadoop.hdfs.security.token.block.BlockTokenIdentifier;
import org.apache.hadoop.security.proto.SecurityProtos;
import org.apache.hadoop.security.token.Token;

@InterfaceAudience.Private
public class ClientDatanodeProtocolServerSideTranslatorPB
implements ClientDatanodeProtocolPB {
    private static final ClientDatanodeProtocolProtos.RefreshNamenodesResponseProto REFRESH_NAMENODE_RESP = ClientDatanodeProtocolProtos.RefreshNamenodesResponseProto.newBuilder().build();
    private static final ClientDatanodeProtocolProtos.DeleteBlockPoolResponseProto DELETE_BLOCKPOOL_RESP = ClientDatanodeProtocolProtos.DeleteBlockPoolResponseProto.newBuilder().build();
    private static final ClientDatanodeProtocolProtos.ShutdownDatanodeResponseProto SHUTDOWN_DATANODE_RESP = ClientDatanodeProtocolProtos.ShutdownDatanodeResponseProto.newBuilder().build();
    private static final ClientDatanodeProtocolProtos.StartReconfigurationResponseProto START_RECONFIG_RESP = ClientDatanodeProtocolProtos.StartReconfigurationResponseProto.newBuilder().build();
    private static final ClientDatanodeProtocolProtos.TriggerBlockReportResponseProto TRIGGER_BLOCK_REPORT_RESP = ClientDatanodeProtocolProtos.TriggerBlockReportResponseProto.newBuilder().build();
    private final ClientDatanodeProtocol impl;

    public ClientDatanodeProtocolServerSideTranslatorPB(ClientDatanodeProtocol impl) {
        this.impl = impl;
    }

    @Override
    public ClientDatanodeProtocolProtos.GetReplicaVisibleLengthResponseProto getReplicaVisibleLength(RpcController unused, ClientDatanodeProtocolProtos.GetReplicaVisibleLengthRequestProto request) throws ServiceException {
        long len;
        try {
            len = this.impl.getReplicaVisibleLength(PBHelper.convert(request.getBlock()));
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return ClientDatanodeProtocolProtos.GetReplicaVisibleLengthResponseProto.newBuilder().setLength(len).build();
    }

    @Override
    public ClientDatanodeProtocolProtos.RefreshNamenodesResponseProto refreshNamenodes(RpcController unused, ClientDatanodeProtocolProtos.RefreshNamenodesRequestProto request) throws ServiceException {
        try {
            this.impl.refreshNamenodes();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return REFRESH_NAMENODE_RESP;
    }

    @Override
    public ClientDatanodeProtocolProtos.DeleteBlockPoolResponseProto deleteBlockPool(RpcController unused, ClientDatanodeProtocolProtos.DeleteBlockPoolRequestProto request) throws ServiceException {
        try {
            this.impl.deleteBlockPool(request.getBlockPool(), request.getForce());
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return DELETE_BLOCKPOOL_RESP;
    }

    @Override
    public ClientDatanodeProtocolProtos.GetBlockLocalPathInfoResponseProto getBlockLocalPathInfo(RpcController unused, ClientDatanodeProtocolProtos.GetBlockLocalPathInfoRequestProto request) throws ServiceException {
        BlockLocalPathInfo resp;
        try {
            resp = this.impl.getBlockLocalPathInfo(PBHelper.convert(request.getBlock()), PBHelper.convert(request.getToken()));
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return ClientDatanodeProtocolProtos.GetBlockLocalPathInfoResponseProto.newBuilder().setBlock(PBHelper.convert(resp.getBlock())).setLocalPath(resp.getBlockPath()).setLocalMetaPath(resp.getMetaPath()).build();
    }

    @Override
    public ClientDatanodeProtocolProtos.GetHdfsBlockLocationsResponseProto getHdfsBlockLocations(RpcController controller, ClientDatanodeProtocolProtos.GetHdfsBlockLocationsRequestProto request) throws ServiceException {
        HdfsBlocksMetadata resp;
        try {
            String poolId = request.getBlockPoolId();
            ArrayList<Token<BlockTokenIdentifier>> tokens = new ArrayList<Token<BlockTokenIdentifier>>(request.getTokensCount());
            for (SecurityProtos.TokenProto b : request.getTokensList()) {
                tokens.add(PBHelper.convert(b));
            }
            long[] blockIds = Longs.toArray(request.getBlockIdsList());
            resp = this.impl.getHdfsBlocksMetadata(poolId, blockIds, tokens);
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        ArrayList<ByteString> volumeIdsByteStrings = new ArrayList<ByteString>(resp.getVolumeIds().size());
        for (byte[] b : resp.getVolumeIds()) {
            volumeIdsByteStrings.add(ByteString.copyFrom(b));
        }
        ClientDatanodeProtocolProtos.GetHdfsBlockLocationsResponseProto.Builder builder = ClientDatanodeProtocolProtos.GetHdfsBlockLocationsResponseProto.newBuilder();
        builder.addAllVolumeIds(volumeIdsByteStrings);
        builder.addAllVolumeIndexes(resp.getVolumeIndexes());
        return builder.build();
    }

    @Override
    public ClientDatanodeProtocolProtos.ShutdownDatanodeResponseProto shutdownDatanode(RpcController unused, ClientDatanodeProtocolProtos.ShutdownDatanodeRequestProto request) throws ServiceException {
        try {
            this.impl.shutdownDatanode(request.getForUpgrade());
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return SHUTDOWN_DATANODE_RESP;
    }

    @Override
    public ClientDatanodeProtocolProtos.GetDatanodeInfoResponseProto getDatanodeInfo(RpcController unused, ClientDatanodeProtocolProtos.GetDatanodeInfoRequestProto request) throws ServiceException {
        ClientDatanodeProtocolProtos.GetDatanodeInfoResponseProto res;
        try {
            res = ClientDatanodeProtocolProtos.GetDatanodeInfoResponseProto.newBuilder().setLocalInfo(PBHelper.convert(this.impl.getDatanodeInfo())).build();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return res;
    }

    @Override
    public ClientDatanodeProtocolProtos.StartReconfigurationResponseProto startReconfiguration(RpcController unused, ClientDatanodeProtocolProtos.StartReconfigurationRequestProto request) throws ServiceException {
        try {
            this.impl.startReconfiguration();
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return START_RECONFIG_RESP;
    }

    @Override
    public ClientDatanodeProtocolProtos.GetReconfigurationStatusResponseProto getReconfigurationStatus(RpcController unused, ClientDatanodeProtocolProtos.GetReconfigurationStatusRequestProto request) throws ServiceException {
        ClientDatanodeProtocolProtos.GetReconfigurationStatusResponseProto.Builder builder = ClientDatanodeProtocolProtos.GetReconfigurationStatusResponseProto.newBuilder();
        try {
            ReconfigurationTaskStatus status = this.impl.getReconfigurationStatus();
            builder.setStartTime(status.getStartTime());
            if (status.stopped()) {
                builder.setEndTime(status.getEndTime());
                assert (status.getStatus() != null);
                for (Map.Entry<ReconfigurationUtil.PropertyChange, Optional<String>> result : status.getStatus().entrySet()) {
                    ClientDatanodeProtocolProtos.GetReconfigurationStatusConfigChangeProto.Builder changeBuilder = ClientDatanodeProtocolProtos.GetReconfigurationStatusConfigChangeProto.newBuilder();
                    ReconfigurationUtil.PropertyChange change = result.getKey();
                    changeBuilder.setName(change.prop);
                    changeBuilder.setOldValue(change.oldVal != null ? change.oldVal : "");
                    if (change.newVal != null) {
                        changeBuilder.setNewValue(change.newVal);
                    }
                    if (result.getValue().isPresent()) {
                        changeBuilder.setErrorMessage(result.getValue().get());
                    }
                    builder.addChanges(changeBuilder);
                }
            }
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return builder.build();
    }

    @Override
    public ClientDatanodeProtocolProtos.TriggerBlockReportResponseProto triggerBlockReport(RpcController unused, ClientDatanodeProtocolProtos.TriggerBlockReportRequestProto request) throws ServiceException {
        try {
            this.impl.triggerBlockReport(new BlockReportOptions.Factory().setIncremental(request.getIncremental()).build());
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return TRIGGER_BLOCK_REPORT_RESP;
    }
}

