/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tracing;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.apache.commons.io.Charsets;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.tracing.SpanReceiverInfo;
import org.apache.hadoop.tracing.TraceAdminProtocol;
import org.apache.hadoop.tracing.TraceUtils;
import org.apache.hadoop.util.ShutdownHookManager;
import org.apache.htrace.SpanReceiver;
import org.apache.htrace.SpanReceiverBuilder;
import org.apache.htrace.Trace;

@InterfaceAudience.Private
public class SpanReceiverHost
implements TraceAdminProtocol {
    public static final String SPAN_RECEIVERS_CONF_SUFFIX = "spanreceiver.classes";
    private static final Log LOG = LogFactory.getLog(SpanReceiverHost.class);
    private static final HashMap<String, SpanReceiverHost> hosts = new HashMap(1);
    private final TreeMap<Long, SpanReceiver> receivers = new TreeMap();
    private final String confPrefix;
    private Configuration config;
    private boolean closed = false;
    private long highestId = 1L;
    private static final String LOCAL_FILE_SPAN_RECEIVER_PATH_SUFFIX = "local-file-span-receiver.path";
    private static List<SpanReceiverInfo.ConfigurationPair> EMPTY = Collections.emptyList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SpanReceiverHost get(Configuration conf, String confPrefix) {
        Class<SpanReceiverHost> clazz = SpanReceiverHost.class;
        synchronized (SpanReceiverHost.class) {
            SpanReceiverHost host = hosts.get(confPrefix);
            if (host != null) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return host;
            }
            final SpanReceiverHost newHost = new SpanReceiverHost(confPrefix);
            newHost.loadSpanReceivers(conf);
            ShutdownHookManager.get().addShutdownHook(new Runnable(){

                @Override
                public void run() {
                    newHost.closeReceivers();
                }
            }, 0);
            hosts.put(confPrefix, newHost);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return newHost;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static String getUniqueLocalTraceFileName() {
        String tmp = System.getProperty("java.io.tmpdir", "/tmp");
        String nonce = null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream("/proc/self/stat"), Charsets.UTF_8));
            String line = reader.readLine();
            if (line == null) {
                throw new EOFException();
            }
            nonce = line.split(" ")[0];
        }
        catch (IOException iOException) {
            IOUtils.cleanup(LOG, reader);
            catch (Throwable throwable) {
                IOUtils.cleanup(LOG, reader);
                throw throwable;
            }
        }
        IOUtils.cleanup(LOG, reader);
        if (nonce == null) {
            nonce = UUID.randomUUID().toString();
        }
        return new File(tmp, nonce).getAbsolutePath();
    }

    private SpanReceiverHost(String confPrefix) {
        this.confPrefix = confPrefix;
    }

    public synchronized void loadSpanReceivers(Configuration conf) {
        this.config = new Configuration(conf);
        String receiverKey = this.confPrefix + SPAN_RECEIVERS_CONF_SUFFIX;
        String[] receiverNames = this.config.getTrimmedStrings(receiverKey);
        if (receiverNames == null || receiverNames.length == 0) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("No span receiver names found in " + receiverKey + ".");
            }
            return;
        }
        String pathKey = this.confPrefix + LOCAL_FILE_SPAN_RECEIVER_PATH_SUFFIX;
        if (this.config.get(pathKey) == null) {
            String uniqueFile = SpanReceiverHost.getUniqueLocalTraceFileName();
            this.config.set(pathKey, uniqueFile);
            if (LOG.isTraceEnabled()) {
                LOG.trace("Set " + pathKey + " to " + uniqueFile);
            }
        }
        for (String className : receiverNames) {
            try {
                SpanReceiver rcvr = this.loadInstance(className, EMPTY);
                Trace.addReceiver(rcvr);
                this.receivers.put(this.highestId++, rcvr);
                LOG.info("Loaded SpanReceiver " + className + " successfully.");
            }
            catch (IOException e) {
                LOG.error("Failed to load SpanReceiver", e);
            }
        }
    }

    private synchronized SpanReceiver loadInstance(String className, List<SpanReceiverInfo.ConfigurationPair> extraConfig) throws IOException {
        SpanReceiverBuilder builder = new SpanReceiverBuilder(TraceUtils.wrapHadoopConf(this.confPrefix, this.config, extraConfig));
        SpanReceiver rcvr = builder.spanReceiverClass(className.trim()).build();
        if (rcvr == null) {
            throw new IOException("Failed to load SpanReceiver " + className);
        }
        return rcvr;
    }

    public synchronized void closeReceivers() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        for (SpanReceiver rcvr : this.receivers.values()) {
            try {
                rcvr.close();
            }
            catch (IOException e) {
                LOG.warn("Unable to close SpanReceiver correctly: " + e.getMessage(), e);
            }
        }
        this.receivers.clear();
    }

    @Override
    public synchronized SpanReceiverInfo[] listSpanReceivers() throws IOException {
        SpanReceiverInfo[] info = new SpanReceiverInfo[this.receivers.size()];
        int i = 0;
        for (Map.Entry<Long, SpanReceiver> entry : this.receivers.entrySet()) {
            info[i] = new SpanReceiverInfo(entry.getKey(), entry.getValue().getClass().getName());
            ++i;
        }
        return info;
    }

    @Override
    public synchronized long addSpanReceiver(SpanReceiverInfo info) throws IOException {
        StringBuilder configStringBuilder = new StringBuilder();
        String prefix = "";
        for (SpanReceiverInfo.ConfigurationPair pair : info.configPairs) {
            configStringBuilder.append(prefix).append(pair.getKey()).append(" = ").append(pair.getValue());
            prefix = ", ";
        }
        SpanReceiver rcvr = null;
        try {
            rcvr = this.loadInstance(info.getClassName(), info.configPairs);
        }
        catch (IOException e) {
            LOG.info("Failed to add SpanReceiver " + info.getClassName() + " with configuration " + configStringBuilder.toString(), e);
            throw e;
        }
        catch (RuntimeException e) {
            LOG.info("Failed to add SpanReceiver " + info.getClassName() + " with configuration " + configStringBuilder.toString(), e);
            throw e;
        }
        Trace.addReceiver(rcvr);
        long newId = this.highestId++;
        this.receivers.put(newId, rcvr);
        LOG.info("Successfully added SpanReceiver " + info.getClassName() + " with configuration " + configStringBuilder.toString());
        return newId;
    }

    @Override
    public synchronized void removeSpanReceiver(long spanReceiverId) throws IOException {
        SpanReceiver rcvr = this.receivers.remove(spanReceiverId);
        if (rcvr == null) {
            throw new IOException("There is no span receiver with id " + spanReceiverId);
        }
        Trace.removeReceiver(rcvr);
        rcvr.close();
        LOG.info("Successfully removed SpanReceiver " + spanReceiverId + " with class " + rcvr.getClass().getName());
    }
}

