/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.InvalidRequestException;
import org.apache.hadoop.hdfs.ExtendedBlockId;
import org.apache.hadoop.hdfs.shortcircuit.ShortCircuitShm;
import org.apache.hadoop.io.nativeio.SharedFileDescriptorFactory;
import org.apache.hadoop.net.unix.DomainSocket;
import org.apache.hadoop.net.unix.DomainSocketWatcher;

public class ShortCircuitRegistry {
    public static final Log LOG = LogFactory.getLog(ShortCircuitRegistry.class);
    private static final int SHM_LENGTH = 8192;
    private boolean enabled;
    private final SharedFileDescriptorFactory shmFactory;
    private final DomainSocketWatcher watcher;
    private final HashMap<ShortCircuitShm.ShmId, RegisteredShm> segments = new HashMap(0);
    private final HashMultimap<ExtendedBlockId, ShortCircuitShm.Slot> slots = HashMultimap.create(0, 1);

    public synchronized void removeShm(ShortCircuitShm shm) {
        RegisteredShm removedShm;
        if (LOG.isTraceEnabled()) {
            LOG.debug("removing shm " + shm);
        }
        Preconditions.checkState((removedShm = this.segments.remove(shm.getShmId())) == shm, "failed to remove " + shm.getShmId());
        ShortCircuitShm.SlotIterator iter = shm.slotIterator();
        while (iter.hasNext()) {
            ShortCircuitShm.Slot slot = (ShortCircuitShm.Slot)iter.next();
            boolean removed = this.slots.remove(slot.getBlockId(), slot);
            Preconditions.checkState(removed);
            slot.makeInvalid();
        }
        shm.free();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ShortCircuitRegistry(Configuration conf) throws IOException {
        boolean enabled = false;
        SharedFileDescriptorFactory shmFactory = null;
        DomainSocketWatcher watcher = null;
        try {
            int interruptCheck = conf.getInt("dfs.short.circuit.shared.memory.watcher.interrupt.check.ms", 60000);
            if (interruptCheck <= 0) {
                throw new IOException("dfs.short.circuit.shared.memory.watcher.interrupt.check.ms was set to " + interruptCheck);
            }
            String[] shmPaths = conf.getTrimmedStrings("dfs.datanode.shared.file.descriptor.paths");
            if (shmPaths.length == 0) {
                shmPaths = "/dev/shm,/tmp".split(",");
            }
            shmFactory = SharedFileDescriptorFactory.create("HadoopShortCircuitShm_", shmPaths);
            String dswLoadingFailure = DomainSocketWatcher.getLoadingFailureReason();
            if (dswLoadingFailure != null) {
                throw new IOException(dswLoadingFailure);
            }
            watcher = new DomainSocketWatcher(interruptCheck, "datanode");
            enabled = true;
            if (LOG.isDebugEnabled()) {
                LOG.debug("created new ShortCircuitRegistry with interruptCheck=" + interruptCheck + ", shmPath=" + shmFactory.getPath());
            }
        }
        catch (IOException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Disabling ShortCircuitRegistry", e);
            }
        }
        finally {
            this.enabled = enabled;
            this.shmFactory = shmFactory;
            this.watcher = watcher;
        }
    }

    public synchronized void processBlockMlockEvent(ExtendedBlockId blockId) {
        if (!this.enabled) {
            return;
        }
        Set affectedSlots = this.slots.get((Object)blockId);
        for (ShortCircuitShm.Slot slot : affectedSlots) {
            slot.makeAnchorable();
        }
    }

    public synchronized boolean processBlockMunlockRequest(ExtendedBlockId blockId) {
        if (!this.enabled) {
            return true;
        }
        boolean allowMunlock = true;
        Set affectedSlots = this.slots.get((Object)blockId);
        for (ShortCircuitShm.Slot slot : affectedSlots) {
            slot.makeUnanchorable();
            if (!slot.isAnchored()) continue;
            allowMunlock = false;
        }
        return allowMunlock;
    }

    public synchronized void processBlockInvalidation(ExtendedBlockId blockId) {
        if (!this.enabled) {
            return;
        }
        Set affectedSlots = this.slots.get((Object)blockId);
        if (!affectedSlots.isEmpty()) {
            StringBuilder bld = new StringBuilder();
            String prefix = "";
            bld.append("Block ").append(blockId).append(" has been invalidated.  ").append("Marking short-circuit slots as invalid: ");
            for (ShortCircuitShm.Slot slot : affectedSlots) {
                slot.makeInvalid();
                bld.append(prefix).append(slot.toString());
                prefix = ", ";
            }
            LOG.info(bld.toString());
        }
    }

    public synchronized String getClientNames(ExtendedBlockId blockId) {
        if (!this.enabled) {
            return "";
        }
        HashSet<String> clientNames = new HashSet<String>();
        Set affectedSlots = this.slots.get((Object)blockId);
        for (ShortCircuitShm.Slot slot : affectedSlots) {
            clientNames.add(((RegisteredShm)slot.getShm()).getClientName());
        }
        return Joiner.on(",").join(clientNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NewShmInfo createNewMemorySegment(String clientName, DomainSocket sock) throws IOException {
        NewShmInfo info = null;
        RegisteredShm shm = null;
        ShortCircuitShm.ShmId shmId = null;
        ShortCircuitRegistry shortCircuitRegistry = this;
        synchronized (shortCircuitRegistry) {
            FileInputStream fis;
            block9: {
                if (!this.enabled) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace("createNewMemorySegment: ShortCircuitRegistry is not enabled.");
                    }
                    throw new UnsupportedOperationException();
                }
                fis = null;
                try {
                    while (this.segments.containsKey(shmId = ShortCircuitShm.ShmId.createRandom())) {
                    }
                    fis = this.shmFactory.createDescriptor(clientName, 8192);
                    shm = new RegisteredShm(clientName, shmId, fis, this);
                    if (shm != null) break block9;
                }
                catch (Throwable throwable) {
                    if (shm == null) {
                        IOUtils.closeQuietly(fis);
                    }
                    throw throwable;
                }
                IOUtils.closeQuietly(fis);
            }
            info = new NewShmInfo(shmId, fis);
            this.segments.put(shmId, shm);
        }
        this.watcher.add(sock, shm);
        if (LOG.isTraceEnabled()) {
            LOG.trace("createNewMemorySegment: created " + info.shmId);
        }
        return info;
    }

    public synchronized void registerSlot(ExtendedBlockId blockId, ShortCircuitShm.SlotId slotId, boolean isCached) throws InvalidRequestException {
        if (!this.enabled) {
            if (LOG.isTraceEnabled()) {
                LOG.trace(this + " can't register a slot because the " + "ShortCircuitRegistry is not enabled.");
            }
            throw new UnsupportedOperationException();
        }
        ShortCircuitShm.ShmId shmId = slotId.getShmId();
        RegisteredShm shm = this.segments.get(shmId);
        if (shm == null) {
            throw new InvalidRequestException("there is no shared memory segment registered with shmId " + shmId);
        }
        ShortCircuitShm.Slot slot = shm.registerSlot(slotId.getSlotIdx(), blockId);
        if (isCached) {
            slot.makeAnchorable();
        } else {
            slot.makeUnanchorable();
        }
        boolean added = this.slots.put((Object)blockId, (Object)slot);
        Preconditions.checkState(added);
        if (LOG.isTraceEnabled()) {
            LOG.trace(this + ": registered " + blockId + " with slot " + slotId + " (isCached=" + isCached + ")");
        }
    }

    public synchronized void unregisterSlot(ShortCircuitShm.SlotId slotId) throws InvalidRequestException {
        if (!this.enabled) {
            if (LOG.isTraceEnabled()) {
                LOG.trace("unregisterSlot: ShortCircuitRegistry is not enabled.");
            }
            throw new UnsupportedOperationException();
        }
        ShortCircuitShm.ShmId shmId = slotId.getShmId();
        RegisteredShm shm = this.segments.get(shmId);
        if (shm == null) {
            throw new InvalidRequestException("there is no shared memory segment registered with shmId " + shmId);
        }
        ShortCircuitShm.Slot slot = shm.getSlot(slotId.getSlotIdx());
        slot.makeInvalid();
        shm.unregisterSlot(slotId.getSlotIdx());
        this.slots.remove(slot.getBlockId(), slot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        ShortCircuitRegistry shortCircuitRegistry = this;
        synchronized (shortCircuitRegistry) {
            if (!this.enabled) {
                return;
            }
            this.enabled = false;
        }
        IOUtils.closeQuietly(this.watcher);
    }

    @VisibleForTesting
    public synchronized void visit(Visitor visitor) {
        visitor.accept(this.segments, this.slots);
    }

    public static interface Visitor {
        public void accept(HashMap<ShortCircuitShm.ShmId, RegisteredShm> var1, HashMultimap<ExtendedBlockId, ShortCircuitShm.Slot> var2);
    }

    public static class NewShmInfo
    implements Closeable {
        public final ShortCircuitShm.ShmId shmId;
        public final FileInputStream stream;

        NewShmInfo(ShortCircuitShm.ShmId shmId, FileInputStream stream) {
            this.shmId = shmId;
            this.stream = stream;
        }

        @Override
        public void close() throws IOException {
            this.stream.close();
        }
    }

    public static class RegisteredShm
    extends ShortCircuitShm
    implements DomainSocketWatcher.Handler {
        private final String clientName;
        private final ShortCircuitRegistry registry;

        RegisteredShm(String clientName, ShortCircuitShm.ShmId shmId, FileInputStream stream, ShortCircuitRegistry registry) throws IOException {
            super(shmId, stream);
            this.clientName = clientName;
            this.registry = registry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean handle(DomainSocket sock) {
            ShortCircuitRegistry shortCircuitRegistry = this.registry;
            synchronized (shortCircuitRegistry) {
                RegisteredShm registeredShm = this;
                synchronized (registeredShm) {
                    this.registry.removeShm(this);
                }
            }
            return true;
        }

        String getClientName() {
            return this.clientName;
        }
    }
}

