/**
   @version 1.20 2004-09-11
   @author Cay Horstmann
*/

import java.io.*;
import java.security.*;
import java.util.*;

/**
   Meneder bezpieczestwa nadzorujcy operacje odczytu plikw.
*/
public class WordCheckSecurityManager extends SecurityManager
{  
   public void checkPermission(Permission p)
   {  
      if (p instanceof FilePermission && p.getActions().equals("read"))
      {  
         if (inSameManager())
            return;
         String fileName = p.getName();
         if (containsBadWords(fileName))
            throw new SecurityException("Bad words in " + fileName);
      }
      else super.checkPermission(p);
   }

   /**
      Zwraca warto true, jeli meneder zosta wywoany
      podczas innego jego wywoania.
      @return warto true, jeli meneder zosta wywoany wielokrotnie
   */
   public boolean inSameManager()
   {  
      Class[] cc = getClassContext();

      // pomija biecy zbir wywoa menedera
      int i = 0;
      while (i < cc.length && cc[0] == cc[i])
         i++;

      // i sprawdza czy istniej jeszcze inne
      while (i < cc.length)
      {  
         if (cc[0] == cc[i]) return true;
         i++;
      }
      return false;
   }

   /**
      Sprawdza, czy plik zawiera zabronione sowa.
      @param fileName nazwa pliku
      @return warto true, jeli nazwa pliku posiada rozszerzenie .txt 
      i plik zawiera co najmniej jedno zabronione sowo.
   */
   boolean containsBadWords(String fileName)
   {  
      if (!fileName.toLowerCase().endsWith(".txt")) return false;
         // sprawdza wycznie pliki tekstowe
      Scanner in; 
      try
      {
         in = new Scanner(new FileReader(fileName));
      }
      catch (IOException e)
      {
         return false;
      }
      while (in.hasNext())
         if (badWords.contains(in.next().toLowerCase()))
         {
            in.close();
            System.out.println(fileName);
            return true;
         }
      return false;
   }

   private List badWords = Arrays.asList(new String[] { "sex", "drugs", "c++" });
}
