/**
   @version 1.03 2004-08-22
   @author Cay Horstmann
*/

import java.awt.*;
import java.awt.event.*;
import java.util.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.Timer;

/**
   Program testujcy dziaanie okna dialogowego monitora postpu.
*/
public class ProgressMonitorTest
{  
   public static void main(String[] args)
   {  
      JFrame frame = new ProgressMonitorFrame();
      frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
      frame.setVisible(true);      
   }
}

/**
   Ramka zawierajca przycisk uruchamiajcy
   symulacj czasochonnej operacji oraz pole tekstowe.
*/
class ProgressMonitorFrame extends JFrame
{  
   public ProgressMonitorFrame()
   {  
      setTitle("ProgressMonitorTest");
      setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);

      // pole tekstowe, w ktrym prezentowane jest dziaanie wtku
      textArea = new JTextArea();

      // tworzy panel przyciskw
      JPanel panel = new JPanel();
      startButton = new JButton("Start");
      panel.add(startButton);

      add(new JScrollPane(textArea), BorderLayout.CENTER);
      add(panel, BorderLayout.SOUTH);

      // dodaje akcj przycisku

      startButton.addActionListener(new 
         ActionListener()
         {  
            public void actionPerformed(ActionEvent event)
            {  
               // uruchamia symulacj
               activity = new SimulatedActivity(1000);
               activityThread = new Thread(activity);
               activityThread.start();

               // uruchomia okno dialogowe monitora
               progressDialog = new ProgressMonitor(ProgressMonitorFrame.this,
                  "Waiting for Simulated Activity", null, 0, activity.getTarget());
               
               // uruchamia licznik czasu
               activityMonitor.start();
               
               startButton.setEnabled(false);
            }
         });

      // konfiguruje akcj licznika czasu

      activityMonitor = new Timer(500, new 
         ActionListener()
         {  
            public void actionPerformed(ActionEvent event)
            {  
               int current = activity.getCurrent();

               // pokazuje postp
               textArea.append(current + "\n");
               progressDialog.setProgress(current);
               
               // sprawdza, czy wtek zakoczy dziaanie lub zosta przerwany
               if (current == activity.getTarget() || progressDialog.isCanceled())
               {  
                  activityMonitor.stop();
                  progressDialog.close();
                  activityThread.interrupt();
                  startButton.setEnabled(true);
               }
            }
         });
   }

   private Timer activityMonitor;
   private JButton startButton;
   private ProgressMonitor progressDialog;
   private JTextArea textArea;
   private Thread activityThread;
   private SimulatedActivity activity;

   public static final int DEFAULT_WIDTH = 300;
   public static final int DEFAULT_HEIGHT = 200;
}

/**
   Klasa symulujca czasochonn operacj.
*/
class SimulatedActivity implements Runnable
{ 
   /**
      Tworzy obiekt symulowanej operacji. Zwiksza on warto licznika
      do momentu osignicia wartoci docelowej.
      @param t warto docelowa licznika.
   */
   public SimulatedActivity(int t)
   {  
      current = 0;
      target = t;
   }

   public int getTarget()
   {  
      return target;
   }

   public int getCurrent()
   {  
      return current;
   }

   public void run()
   {  
      try
      {
         while (current < target)
         {    
            Thread.sleep(100);
            current++;
         }
      }
      catch(InterruptedException e)
      {  
      }
   }

   private volatile int current;
   private int target;
}
