/**
   @version 1.00 1996-09-07
   @author Cay Horstmann
*/

import java.rmi.*;
import java.rmi.server.*;

/**
   Klasa implementacji zdalnych obiektw reprezentujcych produkty.
*/
public class ProductImpl
   extends UnicastRemoteObject
   implements Product
{ 
   /**
      Tworzy implementacj produktu
      @param n nazwa produktu
      @param s sugerowana pe nabywcy (MALE, FEMALE, lub BOTH)
      @param age1 dolna granica wieku nabywcy
      @param age2 grna granica wieku nabywcy
      @param h hobby nabywcy
   */
   public ProductImpl(String n, int s, int age1, int age2,
      String h) throws RemoteException
   {  
      name = n;
      ageLow = age1;
      ageHigh = age2;
      sex = s;
      hobby = h;
   }

   /**
      Sprawdza, czy produkt odpowiada profilowi nabywcy.
      Jest to metoda lokalna i nie naley wobec tego
      do interfejsu Product.
      @param c potencjalny nabywca produktu
      @return true jeli produkt odpowiada profilowi nabywcy

   */
   public boolean match(Customer c)
   {  
      if (c.getAge() < ageLow || c.getAge() > ageHigh)
         return false;
      if (!c.hasHobby(hobby)) return false;
      if ((sex & c.getSex()) == 0) return false;
      return true;
   }

   public String getDescription() throws RemoteException
   {  
      return "To ja - " + name + ". Kup mnie!";
   }

   private String name;
   private int ageLow;
   private int ageHigh;
   private int sex;
   private String hobby;
}
