/**
   @version 1.11 2004-08-15
   @author Cay Horstmann
*/

#include <iostream>

#include "SysProp.hh"

using namespace std;

CORBA::Object_ptr getObjectReference(CORBA::ORB_ptr orb, const char serviceName[])
{  
   CosNaming::NamingContext_var rootContext;

   try
   {  
      // Pobiera referencj do kontekstu w korzeniu usugi nazw:
      CORBA::Object_var initServ;
      initServ = orb->resolve_initial_references("NameService");

      // Zawa typ obiektu zwrconego przez
      // wywoanie resolve_initial_references()
      // do typu CosNaming::NamingContext
      rootContext = CosNaming::NamingContext::_narrow(initServ);
      if (CORBA::is_nil(rootContext))
      {  
         cerr << "Failed to narrow naming context." << endl;
         return CORBA::Object::_nil();
      }
   }
   catch (CORBA::ORB::InvalidName&)
   {  
      cerr << "Name service does not exist." << endl;
      return CORBA::Object::_nil();
   }

   // Tworzy obiekt nazwy zawierajcy nazw corejava/SysProp:
   CosNaming::Name name;
   name.length(1);

   name[0].id   = serviceName;
   name[0].kind = "Object";

   CORBA::Object_ptr obj;
   try
   {  
      // Pobiera referencj obiektu o danej nazwie
      obj = rootContext->resolve(name);
   }
   catch (CosNaming::NamingContext::NotFound&)
   {  
      // Wyjtek wyrzucany, gdy jeden z komponentw 
      // cieki [kontekst lub obiekt] nie zostanie znaleziony:
      cerr << "Context not found." << endl;
      return CORBA::Object::_nil();
   }
   return obj;
}

int main (int argc, char *argv[])
{  
   CORBA::ORB_ptr orb = CORBA::ORB_init(argc, argv, "omniORB4");

   CORBA::Object_var obj = getObjectReference(orb, "SysProp");
   SysProp_var sysProp = SysProp::_narrow(obj);

   if (CORBA::is_nil(sysProp))
   { 
      cerr << "Cannot invoke on a nil object reference."  << endl;
      return 1;
   }

   CORBA::String_var key = "java.vendor";
   CORBA::String_var value = sysProp->getProperty(key);

   cerr << key << "=" << value << endl;

   return 0;
}


