/**
   @version 1.00 1996-09-07
   @author Cay Horstmann
*/

import java.io.*;
import java.rmi.*;
import java.rmi.activation.*;

/**
   Klasa implementacji zdalnych obiektw
   reprezentujcych produkty.
*/
public class ProductImpl
   extends Activatable
   implements Product
{ 
   /**
      Tworzy implementacj produktu
      @param id identyfikator aktywacji
      @param data szeregowany parametr konstruktora (zawiera nazw produktu)
   */
   public ProductImpl(ActivationID id, MarshalledObject data) 
      throws RemoteException, IOException, ClassNotFoundException
   {  
      super(id, 0);
      name = (String) data.get();
      System.out.println("Utworzono: " + name);
   }

   public String getDescription() throws RemoteException
   {  
      return "To ja - " + name + ". Kup mnie!";
   }

   private String name;
}
