/**
   @version 1.12 2004-09-15
   @author Cay Horstmann
*/

import java.util.*;
import javax.swing.*;

/**
   Lista rozwijalna pozwalajca uytkownikowi wybra
   jedn spord wartoci pl statycznych,
   ktrych nazwy zostay przekazane konstruktorowi.
*/
public class EnumCombo extends JComboBox
{ 
   /**
      Tworzy EnumCombo.
      @param cl klasa
      @param labels tablica nazw pl statycznych klasy cl
   */
   public EnumCombo(Class cl, String[] labels)
   {  
      for (int i = 0; i < labels.length; i++)
      {  
         String label = labels[i];
         String name = label.toUpperCase().replace(' ', '_');
         int value = 0;
         try
         {  
            java.lang.reflect.Field f = cl.getField(name);
            value = f.getInt(cl);
         }
         catch (Exception e)
         {  
            label = "(" + label + ")";
         }
         table.put(label, value);
         addItem(label);
      }
      setSelectedItem(labels[0]);
   }

   /**
      Zwraca warto pola wybranego przez uytkownika.
      @return warto pola statycznego
   */
   public int getValue()
   {  
      return table.get(getSelectedItem());
   }

   private Map<String, Integer> table = new TreeMap<String, Integer>();
}

