import java.io.*;
import java.util.*;
import java.util.concurrent.*;

public class ThreadPoolTest
{
   public static void main(String[] args) throws Exception
   {
      Scanner in = new Scanner(System.in);
      System.out.print("Podaj katalog bazowy (np. /usr/local/jdk5.0/src): ");
      String directory = in.nextLine();
      System.out.print("Podaj slowo kluczowe (np. volatile): ");
      String keyword = in.nextLine();     

      ExecutorService pool = Executors.newCachedThreadPool();
      
      MatchCounter counter = new MatchCounter(new File(directory), keyword, pool);           
      Future<Integer> result = pool.submit(counter);

      try
      {
         System.out.println(result.get() + " plikow zawierajacych slowo kluczowe.");
      }
      catch (ExecutionException e)
      {
         e.printStackTrace();
      }
      catch (InterruptedException e) {}
      pool.shutdown();

      int largestPoolSize = ((ThreadPoolExecutor) pool).getLargestPoolSize();
      System.out.println("maksymalny rozmiar puli=" + largestPoolSize);
   }
}

/**
   Zlicza pliki w katalogu i podkatalogach zawierajce podane sowo kluczowe.
*/
class MatchCounter implements Callable<Integer>
{
   /**
      Tworzy MatchCounter.
      @param directory katalog, od ktrego rozpoczyna si wyszukiwanie
      @param keyword poszukiwane sowo kluczowe
      @param pool pula wtkw, ktrej przekazywane s zadania
   */
   public MatchCounter(File directory, String keyword, ExecutorService pool)
   {
      this.directory = directory;      
      this.keyword = keyword;
      this.pool = pool;
   }

   public Integer call()
   {
      count = 0;
      try
      {
         File[] files = directory.listFiles();
         ArrayList<Future<Integer>> results = new ArrayList<Future<Integer>>();

         for (File file : files)      
            if (file.isDirectory()) 
            {               
               MatchCounter counter = new MatchCounter(file, keyword, pool);           
               Future<Integer> result = pool.submit(counter);
               results.add(result);
            }
            else 
            {
               if (search(file)) count++;
            }
         
         for (Future<Integer> result : results)
            try
            {
               count += result.get();
            }
            catch (ExecutionException e)
            {
               e.printStackTrace();
            }
      }
      catch (InterruptedException e) {}
      return count;
   }

   /**
      Wyszukuje sowo kluczowe w pliku.
      @param file przeszukiwany plik
      @return true gdy plik zawiera sowo kluczowe
   */
   public boolean search(File file)
   {     
      try
      {
         Scanner in = new Scanner(new FileInputStream(file));
         boolean found = false;
         while (!found && in.hasNextLine())
         {
            String line = in.nextLine();
            if (line.contains(keyword)) found = true;
         }
         in.close();
         return found;
      }
      catch (IOException e)
      {
         return false;
      }
   }

   private File directory;
   private String keyword;
   private ExecutorService pool;
   private int count;
}


