/**
   @version 1.21 2001-08-15
   @author Cay Horstmann
*/

package com.horstmann.corejava;

import java.awt.*;
import java.io.*;
import javax.imageio.*;
import javax.swing.*;

/**
   Ziarnko wywietlania plikw graficznych.
*/
public class ImageViewerBean extends JLabel
{

   public ImageViewerBean()
   {
      setBorder(BorderFactory.createEtchedBorder());
   }

   /**
      Nadaje warto waciwoci fileName.
      @param fileName nazwa pliku graficznego
   */
   public void setFileName(String fileName)
   {  
      try
      {
         file = new File(fileName);
         setIcon(new ImageIcon(ImageIO.read(file)));
      }
      catch (IOException e)
      {
         file = null;
         setIcon(null);
      }  
   }

   /**
      Zwraca warto waciwoci fileName.
      @return nazwa pliku graficznego
   */
   public String getFileName()
   {  
      if (file == null) return null;
      else return file.getPath();
   }

   public Dimension getPreferredSize()
   {
      return new Dimension(XPREFSIZE, YPREFSIZE);
   }

   private File file = null;
   private static final int XPREFSIZE = 200;
   private static final int YPREFSIZE = 200;
}






