/**
   @version 1.10 1999-08-23
   @author Cay Horstmann
*/

import java.io.*;

/**
   Opis klienta (nabywcy). Obiekty tej klasy nie s zdalne,
   poniewa nie implementuje ona interfejsu Remote.
*/
public class Customer implements Serializable
{  
   /**
      Tworzy obiekt reprezentujcy nabywc.
      @param theAge wiek nabywcy
      @param theSex pe nabywcy (MALE lub FEMALE)
      @param theHobbies hobby nabywcy
   */
   public Customer(int theAge, int theSex, String[] theHobbies)
   {  
      age = theAge;
      sex = theSex;
      hobbies = theHobbies;
   }

   /**
      Zwraca wiek nabywcy.
      @return wiek
   */
   public int getAge() { return age; }

   /**
      Zwraca pe nabywcy.
      @return MALE lub FEMALE
   */
   public int getSex() { return sex; }

   /**
      Sprawdza, czy nabywca posiada okrelone hobby.
      @param aHobby sprawdzane hobby 
      @return true jeli nabywca posiada takie hobby
   */
   public boolean hasHobby(String aHobby)
   {  
      if (aHobby == "") return true;
      for (int i = 0; i < hobbies.length; i++)
         if (hobbies[i].equals(aHobby)) return true;

      return false;
   }

   /**
      Resetuje obiekt nabywcy.
   */
   public void reset()
   {  
      age = 0;
      sex = 0;
      hobbies = null;
   }

   public String toString()
   {  
      String result = "Wiek: " + age + ", Sex: ";
      if (sex == Product.MALE) result += "Mezczyzna";
      else if (sex == Product.FEMALE) result += "Kobieta";
      else result += "Mezczyzna lub kobieta";
      result += ", Hobbies:";
      for (int i = 0; i < hobbies.length; i++)
         result += " " + hobbies[i];
      return result;
   }

   private int age;
   private int sex;
   private String[] hobbies;
}
