/**
   Produkt z opisem i numerem.
*/
public class Item
{ 
   /**
      Konstruktor.
      @param aDescription opis produktu
      @param aPartNumber numer produktu
   */
   public Item(String aDescription, int aPartNumber)
   {  
      description = aDescription;
      partNumber = aPartNumber;
   }

   /**
      Zwraca opis produktu.
      @return opis
   */
   public String getDescription()
   {  
      return description;
   }

   public String toString()
   {  
      return "[description=" + description
         + ", partNumber=" + partNumber + "]";
   }

   @LogEntry(logger="global") public boolean equals(Object otherObject)
   {  
      if (this == otherObject) return true;
      if (otherObject == null) return false;
      if (getClass() != otherObject.getClass()) return false;
      Item other = (Item) otherObject;
      return description.equals(other.description)
         && partNumber == other.partNumber;
   }

   @LogEntry(logger="global") public int hashCode()
   {  
      return 13 * description.hashCode() + 17 * partNumber;
   }

   private String description;
   private int partNumber;
}


