/**
   @version 1.11 2004-08-15
   @author Cay Horstmann
*/

#include <iostream>
#include <cstdlib>

#include "Env.hh"

using namespace std;

class EnvImpl : 
   public POA_Env,
   public PortableServer::RefCountServantBase
{
public:
   virtual char* getenv(const char *name);
};

char* EnvImpl::getenv(const char *name)
{  
   char* value = std::getenv(name);
   return CORBA::string_dup(value);
}

static void bindObjectToName(CORBA::ORB_ptr orb, const char name[], CORBA::Object_ptr objref)
{
   CosNaming::NamingContext_var rootContext;

   try 
   {
      // Pobiera referencj do kontekstu znajdujcego si w korzeniu
      // usugi nazw
      CORBA::Object_var obj;
      obj = orb->resolve_initial_references("NameService");
      
      // Zawa zwrcon referencj.
      rootContext = CosNaming::NamingContext::_narrow(obj);
      if(CORBA::is_nil(rootContext)) 
      {
         cerr << "Failed to narrow the root naming context." << endl;
         return;
      }
   }
   catch (CORBA::ORB::InvalidName& ex) 
   {
      // To si nie powinno zdarzy!
      cerr << "Service required is invalid [does not exist]." << endl;
      return;
   }

   try 
   {
      CosNaming::Name contextName;
      contextName.length(1);
      contextName[0].id   = (const char*) "corejava"; 
      contextName[0].kind = (const char*) "Context"; 

      CosNaming::NamingContext_var corejavaContext;
      try 
      {
         // Wie kontekst z korzeniem.
         corejavaContext = rootContext->bind_new_context(contextName);
      }
      catch (CosNaming::NamingContext::AlreadyBound& ex) 
      {
         // Jeli kontekst ju istnieje, to zostanie wyrzucony wyjtek. 
         // W takim przypadku musimy uzyska odpowiadajcy mu obiekt
         // i zwiza z nim kontekst:
         CORBA::Object_var obj;
         obj = rootContext->resolve(contextName);
         corejavaContext = CosNaming::NamingContext::_narrow(obj);
         if( CORBA::is_nil(corejavaContext) ) 
         {
            cerr << "Failed to narrow naming context." << endl;
            return;
         }
      }

      // Wie objref z dan nazw kontekstu:
      CosNaming::Name objectName;
      objectName.length(1);
      objectName[0].id = name;
      objectName[0].kind = (const char*) "Object"; 

      try 
      {      
         corejavaContext->bind(objectName, objref);
      }
      catch (CosNaming::NamingContext::AlreadyBound& ex) 
      {
         corejavaContext->rebind(objectName, objref);
      }
   }
   catch (CORBA::COMM_FAILURE& ex) 
   {
      cerr << "Caught system exception COMM_FAILURE--unable to contact the naming service." 
         << endl;
   }
   catch (CORBA::SystemException&) 
   {
      cerr << "Caught a CORBA::SystemException while using the naming service." << endl;
   }
}

int main(int argc, char *argv[])
{  
   cout << "Creating and initializing the ORB..." << endl;

   CORBA::ORB_var orb = CORBA::ORB_init(argc, argv, "omniORB4");

   CORBA::Object_var obj = orb->resolve_initial_references("RootPOA");
   PortableServer::POA_var poa = PortableServer::POA::_narrow(obj);
   poa->the_POAManager()->activate();

   EnvImpl* envImpl = new EnvImpl();
   poa->activate_object(envImpl);

   // Pobiera referencj obiektu 
   // i rejestruje go w usudze nazw.

   obj = envImpl->_this();

   cout << orb->object_to_string(obj) << endl;
   cout << "Binding server implementations to registry..." << endl;
   bindObjectToName(orb, "Env", obj);
   envImpl->_remove_ref();

   cout << "Waiting for invocations from clients..." << endl;
   orb->run();

   return 0;
}





