/**
   @version 1.00 2001-09-06
   @author Cay Horstmann
*/

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

/**
   Program prezentujcy moliwo wykorzystania dokumentw XML
   do opisu ukadu komponentw interfejsu uytkownika.
*/
public class GridBagTest
{  
   public static void main(String[] args)
   {  
      String filename = args.length == 0 ? "fontdialog.xml" : args[0];
      JFrame frame = new FontFrame(filename);
      frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
      frame.setVisible(true);
   }
}

/**
   Ramka zawierajca okno dialogowe wyboru czcionki
   opisane przez dokument XML.
   @param filename nazwa pliku zawierajcego opis komponentw interfejsu uytkownika
*/
class FontFrame extends JFrame
{  
   public FontFrame(String filename)
   {  
      setSize(DEFAULT_WIDTH, DEFAULT_HEIGHT);
      setTitle("GridBagTest");

      gridbag = new GridBagPane(filename);
      add(gridbag);

      face = (JComboBox) gridbag.get("face");
      size = (JComboBox) gridbag.get("size");
      bold = (JCheckBox) gridbag.get("bold");
      italic = (JCheckBox) gridbag.get("italic");

      face.setModel(new DefaultComboBoxModel(new Object[]
         {
            "Serif", "SansSerif", "Monospaced", "Dialog", "DialogInput" 
         }));
         
      size.setModel(new DefaultComboBoxModel(new Object[]
         {
            "8", "10", "12", "15", "18", "24", "36", "48" 
         }));

      ActionListener listener = new
         ActionListener()
         {  
            public void actionPerformed(ActionEvent event) { setSample(); }
         };

      face.addActionListener(listener);
      size.addActionListener(listener);
      bold.addActionListener(listener);
      italic.addActionListener(listener);

      setSample();
   }

   /**
      Metoda konfigurujca tekst prezentowany
      za pomoc wybranej czcionki.
   */
   public void setSample()
   {
      String fontFace = (String) face.getSelectedItem();
      int fontSize = Integer.parseInt((String) size.getSelectedItem());
      JTextArea sample = (JTextArea) gridbag.get("sample");
      int fontStyle 
         = (bold.isSelected() ? Font.BOLD : 0) 
         + (italic.isSelected() ? Font.ITALIC : 0);
      
      sample.setFont(new Font(fontFace, fontStyle, fontSize));
      sample.repaint();      
   }

   private GridBagPane gridbag;
   private JComboBox face;
   private JComboBox size;
   private JCheckBox bold;
   private JCheckBox italic;
   private static final int DEFAULT_WIDTH = 400;
   private static final int DEFAULT_HEIGHT = 400;
}
