/**
 * "JUnit. Pragmatyczne testy jednostkowe w Javie"
 * Wydawnictwo Helion, 2006
 */

import junit.framework.*;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;

public class TestRecipe extends TestCase {

  public void testSaveandRestore() throws IOException {

    final String test_name = 
      "Cheeseburger";
    final String test_ing1 = 
      "buka z sezamem";
    final String test_ing2 = 
      "3 plasterki tego sera";
    final String test_ing3 = 
      "2 plasterki poldwicy";

    // Zapisz przepis
    Recipe rec = new Recipe();
    rec.setName(test_name);
    rec.addIngredient(test_ing1);
    rec.addIngredient(test_ing2);
    rec.addIngredient(test_ing3);

    RecipeFile filer = new RecipeFile();
    filer.save("test.recipe", rec);

    try {
      // Odczytaj go
      Recipe rec2 = new Recipe();
      filer = new RecipeFile();
      rec2 = filer.load("test.recipe");
      
      assertEquals(test_name, rec2.getName());
      Iterator itr = rec2.getIngredients();
      
      assertEquals(test_ing1, itr.next());
      assertEquals(test_ing2, itr.next());
      assertEquals(test_ing3, itr.next());
      assertFalse(itr.hasNext());
    } finally {
      new File("test.recipe").delete();
    }

  }
}
