/**
 * "JUnit. Pragmatyczne testy jednostkowe w Javie"
 * Wydawnictwo Helion, 2006
 */

import junit.framework.*;
import java.lang.reflect.Method;

public class TestFinder {

  /* Uwaga: "main" zostanie wykonana 
   * tylko na skutek indywidualnego wywoania 
   * z wiersza polece (a nie przez zadanie JUnit programu Ant lub podobny sposb)
   * Poniszy kod dynamicznie tworzy zestaw testw 
   * w oparciu o argumenty podane w wierszu polece
   * lub zastosowanie mechanizmu refleksji dla danej klasy.
   */
  
  public static void run(Class which, String[] args) {
    
    TestSuite suite = null;
    
    if (args.length != 0) {
      // Wykonuje okrelone testy podane w wierszu polece

      try {
        java.lang.reflect.Constructor ctor;
        ctor = which.getConstructor(new Class[] 
          {String.class});
        suite = new TestSuite();
        for (int i=0; i< args.length; i++) {
          suite.addTest((TestCase)ctor.newInstance(
                                      new Object[]{args[i]}));
        }
      } catch (Exception e) {
        System.err.println("Brak instancji " + 
                           which.getName() + 
                           ": " + e.getMessage());
        System.exit(1);
      }
      
    } else {
      // Wywouje metod suite() danej klasy, 
      // jeli metoda taka istnieje
      try {
        Method suite_method = which.getMethod("suite", 
                                              new Class[0]);
        suite = (TestSuite) suite_method.invoke(null, 
                                                null);
      } catch (Exception e) {
        // Klasa nie posiada publicznej metody suite().  
        // Utwrz domyln list testw za pomoc refleksji:
        suite = new TestSuite(which);
      }
    }
    
    junit.textui.TestRunner.run(suite);
  }
}
