/**
 * "JUnit. Pragmatyczne testy jednostkowe w Javie"
 * Wydawnictwo Helion, 2006
 */

import java.util.ArrayList;

public class MockMp3Player implements Mp3Player {

  // Stan odtwarzacza
  private boolean isPlaying = false;

  // Pozycja biecego utworu
  private double currentPos = 0.0;

  // Lista nazw utworw
  private ArrayList songList = new ArrayList();

  // Indeks biecego utworu
  private int currentIndex;

  public void play() {
    if (songList.size() > 0) {
      isPlaying = true;
      // Odtwarzanie oznacza w tym przypadku
      // pozycj biecego utworu rwn 1 sekundzie.  
      // Bardziej realistyczna implementacja wymagaaby
      // uycia licznika czasu w osobnym wtku, ktry
      // zwikszaby sw warto i powodowa przejcie 
      // do nastpnego utworu.
      currentPos = 1.0; 
    } else {
      isPlaying = false;
      currentPos = 0.0; 
    }
  }

  public void pause() {
    isPlaying = false;
  }

  public void stop() {
    isPlaying = false;
    // Przewi na pocztek biecego utworu
    currentPos = 0.0; 
  }
  
  public double currentPosition() {
    return currentPos;
  }

  public String currentSong() {
    if (songList.size() == 0) {
      return null;
    }
    return (String)songList.get(currentIndex);
  }

  public void next() {
    if (currentIndex < songList.size()-1) {
      currentIndex++;
    }
    currentPos = 0.0; 
  }

  public void prev() {
    if (currentIndex > 0) {
      currentIndex--;
    }
    currentPos = 0.0; 
  }

  public boolean isPlaying() {
    return isPlaying;
  }

  public void loadSongs(ArrayList names) {
    songList = names;
  }

}
