/**
 * "JUnit. Pragmatyczne testy jednostkowe w Javie"
 * Wydawnictwo Helion, 2006
 */

import junit.framework.*;
import junit.extensions.*;

public class TestClassTwo extends TestCase {

  private static TSP tsp;
  
  public TestClassTwo(String method) {
    super(method);
  }
  
  // Wykonanie tego testu zabiera kilka godzin...
  public void testLongRunner() {
    assertEquals(2300, tsp.shortestPath(50));
  }
  
  public void testShortTest() {
    assertEquals(140, tsp.shortestPath(5));
  }
  
  public void testAnotherShortTest() {
    assertEquals(586, tsp.shortestPath(10));
  }
  
  public static Test suite() {
    TestSuite suite = new TestSuite();
    // Zestaw najkrtszych testw
    suite.addTest(new TestClassTwo("testShortTest"));
    suite.addTest(new TestClassTwo(
                               "testAnotherShortTest"));

    TestSetup wrapper = new TestSetup(suite) {
        protected void setUp() {
          oneTimeSetUp();
        }
        protected void tearDown() {
          oneTimeTearDown();
        }
      };
    
    return wrapper;
  }
  
  public static void oneTimeSetUp() {
    // Tutaj umieszczamy kod inicjalizacji
    // wykonywany tylko jeden raz...
    tsp = new TSP();
    tsp.loadCities("EasternSeaboard");
  }
  
  public static void oneTimeTearDown() {
    // Tutaj umieszczamy kod zwalniania zasobw
    // wykonywany tylko jeden raz...
    tsp.releaseCities();
  }

}
