/**
 * "JUnit. Pragmatyczne testy jednostkowe w Javie"
 * Wydawnictwo Helion, 2006
 */

import java.util.ArrayList;

public interface Mp3Player {

  /** 
   * Rozpocznij odtwarzanie 
   * od utworu znajdujcego si na szczycie listy
   * utworw lub nie rb nic gdy lista jest pusta. 
   */
  public void play();

  /** 
   * Wstrzymaj odtwarzanie. Odtwarzanie bdzie 
   * pniej wznowione od tego miejsca.
   */
  public void pause();

  /** 
   * Zatrzymajmodtwarzanie. Biecy utwr pozostaje
   * na szczycie listy, ale odtwarzanie zostanie
   * wznowione od jego pocztku.
   */
  public void stop();
  
  /** Zwraca liczb sekund od pocztku 
   * biecego utworu.
   */
  public double currentPosition();


  /**
   * Zwraca nazw odtwarzanego pliku.
   */
  public String currentSong();

  /** 
   * Przechodzi do nastpnego utworu na licie 
   * i rozpoczyna jego odtwarzanie.
   */
  public void next();

  /**
   * Wraca do poprzedniego utworu na licie 
   * i rozpoczyna jego odtwarzanie.
   */
  public void prev();

  /** 
   * Zwraca true gdy odtwarzany jest utwr. 
   */
  public boolean isPlaying();

  /**
   * aduje pliki na list utworw.
   */
  public void loadSongs(ArrayList names);
}
