/** @license MIT License (c) copyright 2010-2014 original author or authors */
/** @author Brian Cavalier */
/** @author John Hann */

(function(define) { 'use strict';
define(function(require) {
	/*global setTimeout,clearTimeout*/
	var cjsRequire, vertx, setTimer, clearTimer;

	// Check for vertx environment by attempting to load vertx module.
	// Doing the check in two steps ensures compatibility with RaveJS,
	// which will return an empty module when browser: { vertx: false }
	// is set in package.json
	cjsRequire = require;

	try {
		vertx = cjsRequire('vertx');
	} catch (ignored) {}

	// If vertx loaded and has the timer features we expect, try to support it
	if (vertx && typeof vertx.setTimer === 'function') {
		setTimer = function (f, ms) { return vertx.setTimer(ms, f); };
		clearTimer = vertx.cancelTimer;
	} else {
		// NOTE: Truncate decimals to workaround node 0.10.30 bug:
		// https://github.com/joyent/node/issues/8167
		setTimer = function(f, ms) { return setTimeout(f, ms|0); };
		clearTimer = function(t) { return clearTimeout(t); };
	}

	return {
		set: setTimer,
		clear: clearTimer
	};

});
}(typeof define === 'function' && define.amd ? define : function(factory) { module.exports = factory(require); }));
