@echo off
if "%JSTK_HOME%" == "" goto jstkHomeNotFound
if not exist "%JSTK_HOME%\build\jstk.jar" goto jstkJarNotFound

set OLDCPATH=%CLASSPATH%
set CLASSPATH=%JSTK_HOME%\build\jstk.jar;.

echo compiling the .java files

%JAVA_HOME%\bin\javac common\*.java
if errorlevel 1 goto eof
%JAVA_HOME%\bin\javac server\*.java
if errorlevel 1 goto eof
%JAVA_HOME%\bin\javac client\*.java
if errorlevel 1 goto eof

echo running the RMI compiler
%JAVA_HOME%\bin\rmic server.RemoteBankImpl
%JAVA_HOME%\bin\rmic server.RemoteAccountImpl
%JAVA_HOME%\bin\rmic server.RemoteIteratorImpl

if exist org goto orgExists
jar xf %JSTK_HOME%\build\jstk.jar org

echo creating the .jar files.
:orgExists
jar cf client.jar client\*.class org\jstk\example\bank\client\*.class org\jstk\*.class
jar cf server.jar server\*.class org\jstk\example\bank\server\*.class
jar cf common.jar common\*.class org\jstk\example\bank\*.class
jar cf server_stub.jar server\*_Stub.class
del client\*.class
del server\*.class
del common\*.class
goto eof

:jstkJarNotFound
echo jstk.jar not found in %JSTK_HOME%\build directory.
got eof
:jstkHomeNotFound
echo Set environment variable JSTK_HOME to the full path of JSTK installation directory
:eof
set CLASSPATH=%OLDCPATH%