/*
 * @(#) $Id: IteratorProxy.java,v 1.1.1.1 2003/10/05 18:39:08 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
package client;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.Iterator;
import common.RemoteIterator;
import common.RemoteAccount;

public class IteratorProxy implements Iterator {
	private RemoteIterator ri;
	public IteratorProxy(RemoteIterator ri){
		this.ri = ri;
	}
	public boolean hasNext(){
		try {
			return ri.hasNext();
		} catch (RemoteException re){
			throw new RuntimeException(re);
		}
	}
	public Object next(){
		try {
			return new AccountProxy((RemoteAccount)ri.next());
		} catch (RemoteException re){
			throw new RuntimeException(re);
		}
	}
	public void remove(){
		try {
			ri.remove();
		} catch (RemoteException re){
			throw new RuntimeException(re);
		}
	}
}
