/*
 * @(#) $Id: DisplayFileLauncher.java,v 1.1.1.1 2003/10/05 18:39:06 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import java.security.PrivilegedExceptionAction;

public class DisplayFileLauncher {
    public static void main(String[] args) throws Exception {
		if (args.length < 1){
			System.out.println("Usage:: java DisplayFile <filename>");
			return;
		}
		final String fileName = args[0];
		LoginContext lc = new LoginContext("DF", new DFCallbackHandler());
		lc.login();
		PrivilegedExceptionAction action = new PrivilegedExceptionAction() {
			public Object run() throws Exception{
				DisplayFile df = new DisplayFile();
				df.disp(fileName);
				return null;
			}
		};
		Subject.doAs(lc.getSubject(), action);
    }
}
