/*
 * @(#) $Id: BCSecureShell.java,v 1.1.1.1 2003/10/05 18:39:05 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
import java.io.InputStreamReader;
import java.io.BufferedReader;
import org.jstk.example.bank.BankIntf;
import org.jstk.example.bank.server.DefaultBankPersistenceManager;
import org.jstk.example.bank.client.BankClient;
import org.jstk.uam.DefaultCallbackHandler;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import java.security.PrivilegedExceptionAction;

public class BCSecureShell {
    public static void main(String[] args) throws Exception {
		final BankClient bc = new BankClient();
		DefaultBankPersistenceManager bpm =
					new DefaultBankPersistenceManager(System.getProperties());
		BankIntf bank = bpm.load();
		bc.init(bank);
		LoginContext lc = new LoginContext("BCSecureShell", new DefaultCallbackHandler());
		try {
			lc.login();
		} catch (javax.security.auth.login.LoginException le){
			System.err.println("Login failed. Exception: " + le);
			return;
		}
		PrivilegedExceptionAction action = new PrivilegedExceptionAction() {
			public Object run() throws Exception{

				while (true){
					System.out.print("bcssh>");
					System.out.flush();
					String cmdline = new BufferedReader(new InputStreamReader(System.in)).readLine();
					String[] cmdargs = cmdline.split("\\s");

					String result = bc.execCommand(cmdargs);
					System.out.println(result);
				}
			}
		};
		Subject.doAs(lc.getSubject(), action);

	}
}