/*
 * @(#) $Id: EchoClient2.java,v 1.1.1.1 2003/10/05 18:39:02 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
import javax.xml.namespace.QName;
import javax.xml.rpc.ServiceFactory;
import javax.xml.rpc.Service;
import javax.xml.rpc.Call;

public class EchoClient2 {
    public static void main(String [] args) throws Exception {
		String epAddr = "https://localhost:8443/axis/services/StringEchoPort1";
        String wsdlAddr = epAddr + "?wsdl";
        String nameSpaceUri = "http://www.pankaj-k.net/jsbook/examples/";
        String svcName = "StringEchoService1";
        String portName = "StringEchoPort1";

        java.net.URL wsdlUrl = new java.net.URL(wsdlAddr);
        ServiceFactory svcFactory = ServiceFactory.newInstance();
        QName svcQName = new QName(nameSpaceUri, svcName);
        Service svc = svcFactory.createService(wsdlUrl, svcQName);

        Call call = (Call) svc.createCall();

        call.setTargetEndpointAddress(epAddr);
        call.setOperationName( new QName(nameSpaceUri, "echo") );
        call.setPortTypeName( new QName(nameSpaceUri, portName) );

		Object arg = "Hi, How are you?";
		System.out.println("sending: " + arg );
        String res = (String) call.invoke(new Object[] {arg});
        System.out.println("received: " + res );
    }
}
