/*
 * @(#) $Id: SampleAction.java,v 1.1.1.1 2003/10/05 18:38:59 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
package client;

import java.security.PrivilegedAction;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import java.rmi.RemoteException;
import javax.naming.NamingException;
import echo.Echo;
import echo.EchoHome;

public class SampleAction implements PrivilegedAction {
	private static final String JNDI_NAME = "ex2-echo-EchoHome";
	private String url;

	public SampleAction(String url){
		this.url = url;
	}

	public Object run(){
		Object obj = null;

		try {
			doit();
		} catch(Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public void doit() throws NamingException, CreateException, RemoteException, RemoveException {
		Properties h = new Properties();

		//h.put(Context.INITIAL_CONTEXT_FACTORY, "com.sun.jndi.cosnaming.CNCtxFactory");
		h.put(Context.INITIAL_CONTEXT_FACTORY, "weblogic.jndi.WLInitialContextFactory");

		h.put(Context.PROVIDER_URL, url);
		Context ctx = new InitialContext(h);

		Object home = ctx.lookup("ex2-echo-EchoHome");
		EchoHome ehome = (EchoHome)narrow(home, EchoHome.class);
		Echo estub = (Echo)narrow(ehome.create(), Echo.class);

		String msg = "Hello, World!!";
		System.out.println("Calling Echo.echo(\"" + msg + "\") ...");
		String resp = estub.echo(msg);
		System.out.println("... Echo.echo(\"" + msg + "\") = " + resp);

		System.out.println("... Echo Client Executed successfully.");
	}
	private Object narrow(Object o, Class c){
		return javax.rmi.PortableRemoteObject.narrow(o, c);
	}
}

