/*
 * @(#) $Id: Transaction.java,v 1.1.1.1 2003/10/05 18:39:19 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
package org.jstk.example.bank.server;

import java.math.BigDecimal;
import java.util.Date;

public class Transaction implements java.io.Serializable {
	public static String OPEN = "OPEN";
	public static String CLOSE = "CLOSE";
	public static String DEBIT = "DEBIT";
	public static String CREDIT = "CREDIT";

	private String type;
	private BigDecimal amt;
	private BigDecimal balance;
	private String desc;
	private Date date;

	public Transaction(String type, BigDecimal amt, BigDecimal balance, String desc){
		this.type = type;
		this.amt = amt;
		this.balance = balance;
		this.desc = desc;
		date = new Date();
	}

	public String toString(){
		return date.toString() + "   " + type + "   " + amt + "   " + balance + "  " + desc;
	}
}