/*
 * @(#) $Id: Bank.java,v 1.1.1.1 2003/10/05 18:39:19 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
package org.jstk.example.bank.server;

import java.math.BigInteger;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import org.jstk.example.bank.*;
import java.security.AccessController;

public class Bank implements BankIntf, java.io.Serializable {
	private BigInteger nextAcctNo;
	private HashMap acctsTable = null;
	private transient BankPersistenceManagerIntf pmi = null;

	public Bank(){
		nextAcctNo = new BigInteger("1000");
		acctsTable = new HashMap();
	}
	public void setPersistenceManager(BankPersistenceManagerIntf pmi){
		this.pmi = pmi;
	}
	public AccountIntf openAccount(BigDecimal initialDeposit){
		checkPermission("*", "open");
		SecurityManager security = System.getSecurityManager();
		Account acct = new Account(nextAcctNo.toString());
		try {
			acct.deposit(initialDeposit);
		} catch (Exceptions.AccountClosed ac){
			// Nothing.
		}
		acctsTable.put(acct.getAcctNo(), acct);
		nextAcctNo = nextAcctNo.add(BigInteger.ONE);
		if (pmi != null){
			acct.setPersistenceManager(pmi);
			pmi.save();
		}
		return acct;
	}
	public void closeAccount(String acctNo)
			throws Exceptions.AccountNotFound, Exceptions.AccountClosed{
		checkPermission(acctNo, "close");
		Account acct = (Account)acctsTable.get(acctNo);
		if (acct != null)
			acct.close();
		else
			throw new Exceptions.AccountNotFound();
		if (pmi != null)
			pmi.save();
	}
	public AccountIntf getAccount(String acctNo) throws Exceptions.AccountNotFound{
		checkPermission(acctNo, "get");
		Account acct = (Account)acctsTable.get(acctNo);
		if (acct == null)
			throw new Exceptions.AccountNotFound();
		return acct;
	}
	public Iterator accounts(){
		checkPermission("*", "list");
		return acctsTable.values().iterator();
	}
	Iterator _accounts(){
		return acctsTable.values().iterator();
	}
	private void checkPermission(String name, String action){
		SecurityManager security = System.getSecurityManager();
		if (security != null) {
			BankPermission bp = new BankPermission(name, action);
			AccessController.checkPermission(bp);
		}
	}

	public static void main(String[] args) throws Exception{
		Bank bank = new Bank();
		Account acct1 = (Account)bank.openAccount(new BigDecimal("100.0"));
		Account acct2 = (Account)bank.openAccount(new BigDecimal("200.0"));
		acct2.deposit(new BigDecimal("4000.0"));
		acct2.withdraw(new BigDecimal("3000.0"));

		Iterator itr = bank.accounts();
		int idx = 0;
		while (itr.hasNext()){
			Account acct = (Account)itr.next();
			System.out.println("Account[" + idx + "]: " + acct);
			System.out.print(acct.getStatement());
			System.out.flush();
			++idx;
		}
	}
}