/*
 * @(#) $Id: JSTKOptions.java,v 1.1.1.1 2003/10/05 18:39:11 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
package org.jstk;

import java.util.HashMap;
import java.util.Vector;

public class JSTKOptions implements JSTKArgs {
	private HashMap options = new HashMap();
	private HashMap defaults = null;
	private Vector pArgs = new Vector();	// Positional Args.

	public void parse(String[] args, int beginIndex){
		String key, value;
		int index = beginIndex;
		while (args.length > index){
			value = "true";
			if (args[index].startsWith("-")){
				key = args[index++].substring(1);
				if (args.length > index && !args[index].startsWith("-"))
					value = args[index++];
				set(key, value);
			} else {
				pArgs.add(args[index]);
				++index;
			}
		}
	}

	public int getNum(){
		return pArgs.size();
	}

	public void setDefaults(HashMap defaults){
		this.defaults = defaults;
	}
	public String get(String name){
		String value = (String)options.get(name);
		if (value == null && defaults != null)
			value = (String)defaults.get(name);
		return value;
	}
	public String get(int pos){
		return (String)pArgs.elementAt(pos);
	}

	public void set(String name, String value){
		options.put(name, value);
	}
}