/*
 * @(#) $Id: RemoteAccountImpl.java,v 1.1.1.1 2003/10/05 18:39:08 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
package server;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.math.BigDecimal;
import org.jstk.example.bank.Exceptions;
import org.jstk.example.bank.AccountIntf;

public class RemoteAccountImpl extends UnicastRemoteObject implements common.RemoteAccount {
	private AccountIntf acct = null;

	public RemoteAccountImpl(AccountIntf acct) throws RemoteException {
		this.acct = acct;
	}
	public void deposit(BigDecimal amt) throws Exceptions.AccountClosed, RemoteException {
		acct.deposit(amt);
	}
	public void withdraw(BigDecimal amt) throws Exceptions.AccountClosed,
			Exceptions.InsufficientAmount, RemoteException {
		acct.withdraw(amt);
	}
	public void close() throws Exceptions.AccountClosed, RemoteException {
		acct.close();
	}
	public BigDecimal getBalance() throws Exceptions.AccountClosed, RemoteException {
		return acct.getBalance();
	}
	public String getAcctNo() throws RemoteException {
		return acct.getAcctNo();
	}
	public String getStatement() throws RemoteException {
		return acct.getStatement();
	}
}
