/*
 * @(#) $Id: ComputeDigest.java,v 1.1.1.1 2003/10/05 18:39:04 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
import java.security.MessageDigest;
import java.io.FileInputStream;

public class ComputeDigest {
	public static void main(String[] unused) throws Exception{
		String datafile = "ComputeDigest.java";

    	MessageDigest md = MessageDigest.getInstance("SHA1");
    	FileInputStream fis = new FileInputStream(datafile);
    	byte[] dataBytes = new byte[1024];
    	int nread = fis.read(dataBytes);
    	while (nread > 0) {
			md.update(dataBytes, 0, nread);
			nread = fis.read(dataBytes);
		};
		byte[] mdbytes = md.digest();
		System.out.println("Digest(in hex):: " + Util.byteArray2Hex(mdbytes));
	}
}