/*
 * @(#) $Id: WSSEncrypt.java,v 1.1.1.1 2003/10/05 18:39:03 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */

import java.io.FileInputStream;
import java.io.ObjectInputStream;
import java.io.FileOutputStream;
import org.w3c.dom.Document;
import java.security.PublicKey;
import javax.crypto.SecretKey;
import java.security.cert.X509Certificate;

import com.verisign.xmlsig.KeyInfo;
import com.verisign.messaging.WSSecurity;
import com.verisign.xmlenc.AlgorithmType;
import com.verisign.xpath.XPath;

public class WSSEncrypt {
	public static void main(String[] args) throws Exception {
		if (args.length < 1){
			System.out.println("Usage:: java WSSEncrypt <inp-file> [<out-file>]");
			return;
		}
		String datafile = args[0];
		String outfile = "encrypted.xml";
		if (args.length > 1)
			outfile = args[1];

		String keystore = "my.keystore";
		String storepass = "changeit";
		String kstype = "JCEKS";
		String alias = "rsakey";
		String keyfile = "3des.key";

		System.out.println("Encrypting XML data in file \"" + datafile + "\"");
		System.out.println("Using secret key in file \"" + keyfile + "\" ...");
		System.out.println("And encrypting the secret key");
		System.out.println("Using public key in \"" + keystore + "\" at alias \"" + alias + "\"...");

		// Get the private key and corresponding certificate.
		FileInputStream fis = new FileInputStream(keystore);
		java.security.KeyStore ks = java.security.KeyStore.getInstance(kstype);
		ks.load(fis, storepass.toCharArray());
		X509Certificate cert = (X509Certificate)ks.getCertificate(alias);
		PublicKey pubk = cert.getPublicKey();

		ObjectInputStream ois = new ObjectInputStream(new FileInputStream(keyfile));
		SecretKey key = (SecretKey)ois.readObject();

		// Read the XML file
		Document doc = XmlUtility.readXML(datafile);
		KeyInfo ki = new KeyInfo();
		ki.setCertificate(cert);

		WSSecurity wss = new WSSecurity();
		wss.encrypt(doc, key, AlgorithmType.TRIPLEDES, pubk, AlgorithmType.RSA1_5, ki);

		// Write the signed XML file
		XmlUtility.writeXML(doc, new FileOutputStream(outfile));
		System.out.println("... Wrote the output to file: \"" + outfile + "\"");
	}
}