/*
 * @(#) $Id: SampleAction.java,v 1.1.1.1 2003/10/05 18:39:00 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
package client;

import java.security.PrivilegedAction;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.rmi.PortableRemoteObject;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import javax.ejb.RemoveException;
import java.rmi.RemoteException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import echo.*;

public class SampleAction implements PrivilegedAction {
	private static final String JNDI_NAME = "ex3-echo-EchoHome";
	private String url;

	public SampleAction(String url){
		this.url = url;
	}

	public Object run(){
		Object obj = null;

		try {
			doit();
		} catch(Exception e) {
			e.printStackTrace();
		}
		return obj;
	}

	public void doit() throws NamingException, CreateException, RemoteException, RemoveException {
		System.out.println("Looking for  EchoHome ...");
		EchoHome home = lookupHome();
		System.out.println("... EchoHome Found.");

		System.out.println("Creating a Echo stub ...");
		Echo estub = (Echo) PortableRemoteObject.narrow(home.create(), Echo.class);
		System.out.println("... Echo stub created.");

		String msg = "Hello, World!!";
		System.out.println("Calling estub.echo(\"" + msg + "\")...");
		String resp = estub.echo(msg);
		System.out.println("Returned String -- " + resp);

		System.out.println("... Echo Client Executed successfully.");
	}

	private EchoHome lookupHome() throws NamingException {
		Context ctx = getInitialContext();

		try {
			Object home = ctx.lookup(JNDI_NAME);
			return (EchoHome) PortableRemoteObject.narrow(home, EchoHome.class);
		} catch (NamingException ne) {
			System.out.println("The client was unable to lookup the EJBHome.  Please make sure ");
			System.out.println("that you have deployed the ejb with the JNDI name ");
			System.out.println(JNDI_NAME + " on the WebLogic server at " + url);
			throw ne;
		}
	}

	private Context getInitialContext() throws NamingException {
		try {
			// Get an InitialContext
			Properties h = new Properties();
			h.put(Context.INITIAL_CONTEXT_FACTORY, "weblogic.jndi.WLInitialContextFactory");
			//h.put(Context.INITIAL_CONTEXT_FACTORY, "com.sun.jndi.cosnaming.CNCtxFactory");

			h.put(Context.PROVIDER_URL, url);
			return new InitialContext(h);
		} catch (NamingException ne) {
			System.out.println("Unable to get a connection to the server at " + url);
			System.out.println("exception: " + ne);
			throw ne;
		}
	}
}

