/*
 * @(#) $Id: SampleCallbackHandler.java,v 1.1.1.1 2003/10/05 18:38:59 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
package client;

import java.io.*;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.NameCallback;
import weblogic.security.auth.callback.URLCallback;

/**
 * SampleCallbackHandler.java
 * Implementation of the CallbackHandler Interface
 *
 * @author Copyright (c) 2000-2002 by BEA Systems, Inc. All Rights Reserved.
 */
class SampleCallbackHandler implements CallbackHandler
{
  private String username = null;
  private String password = null;
  private String url = null;

  public SampleCallbackHandler() { }

  public SampleCallbackHandler(String pUsername, String pPassword, String pUrl)
  {
    username = pUsername;
    password = pPassword;
    url = pUrl;
  }

  public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException
  {
    for(int i = 0; i < callbacks.length; i++)
    {
      if(callbacks[i] instanceof TextOutputCallback)
      {
        // Display the message according to the specified type
        TextOutputCallback toc = (TextOutputCallback)callbacks[i];
        switch(toc.getMessageType())
        {
        case TextOutputCallback.INFORMATION:
          System.out.println(toc.getMessage());
          break;
        case TextOutputCallback.ERROR:
          System.out.println("ERROR: " + toc.getMessage());
          break;
        case TextOutputCallback.WARNING:
          System.out.println("WARNING: " + toc.getMessage());
          break;
        default:
          throw new IOException("Unsupported message type: " + toc.getMessageType());
        }
      }
      else if(callbacks[i] instanceof NameCallback)
      {
        // If username not supplied on cmd line, prompt the user for the username.
        NameCallback nc = (NameCallback)callbacks[i];
        if (username == null) {
          System.err.print(nc.getPrompt());
          System.err.flush();
          nc.setName((new BufferedReader(new InputStreamReader(System.in))).readLine());
        }
        else {
          System.out.println("username: "+username);
          nc.setName(username);
        }
      }
      else if(callbacks[i] instanceof URLCallback)
      {
        // If url not supplied on cmd line, prompt the user for the url.
        // This example requires the url.
        URLCallback uc = (URLCallback)callbacks[i];
        if (url == null) {
          System.err.print(uc.getPrompt());
          System.err.flush();
          uc.setURL((new BufferedReader(new InputStreamReader(System.in))).readLine());
        }
        else {
          System.out.println("URL: "+url);
          uc.setURL(url);
        }
      }
      else if(callbacks[i] instanceof PasswordCallback)
      {
        PasswordCallback pc = (PasswordCallback)callbacks[i];

        // If password not supplied on cmd line, prompt the user for the password.
        if (password == null) {
          System.err.print(pc.getPrompt());
          System.err.flush();

          // Note: JAAS specifies that the password is a char[] rather than a String
          String tmpPassword = (new BufferedReader(new InputStreamReader(System.in))).readLine();
          int passLen = tmpPassword.length();
          char[] passwordArray = new char[passLen];
          for(int passIdx = 0; passIdx < passLen; passIdx++)
            passwordArray[passIdx] = tmpPassword.charAt(passIdx);
          pc.setPassword(passwordArray);
        }
        else {
          String tPass = new String();
          for(int p = 0; p < password.length(); p++)
            tPass += "*";
          System.out.println("password: "+tPass);
          pc.setPassword(password.toCharArray());
        }
      }
      else if(callbacks[i] instanceof TextInputCallback)
      {
        // Prompt the user for the username
        TextInputCallback callback = (TextInputCallback)callbacks[i];
        System.err.print(callback.getPrompt());
        System.err.flush();
        callback.setText((new BufferedReader(new InputStreamReader(System.in))).readLine());
      }
      else
      {
        throw new UnsupportedCallbackException(callbacks[i], "Unrecognized Callback");
      }
    }
  }
}
