#! /bin/sh

printHelp()
{
  echo "Usage :: ./sslsetup.sh <arg1> [<arg2>]"
  echo
  echo "Where <arg1> is one of:"
  echo "   ss-certs : keystore and truststore with self signed certs."
  echo "   cs-certs : keystore with CA signed certs and truststore with CA cert."
  echo "   server-env : sets environment variable JSTK_OPTS for server program."
  echo "   client-env : sets environment variable JSTK_OPTS for client program."
  echo
  echo "This program removes existing files client.ks, client.ts, server.ks "
  echo "and server.ts from the current diretory and creates new ones for"
  echo "ss-certs and cs-certs options."
}

SelfSignedCerts()
{
  rm -f *.ks *.ts
  KEYINFO="-keyalg RSA"

  echo "Creating a server certificate in keystore server.ks, exporting it"
  echo "to a temporary file, and then importing it to client truststore client.ts"
  echo ""
  ${JAVA_HOME}/bin/keytool -genkey -dname "$SERVER_DN" $STOREINFO -keystore server.ks $KEYINFO
  ${JAVA_HOME}/bin/keytool -export -file temp.cer $STOREINFO -keystore server.ks
  ${JAVA_HOME}/bin/keytool -import -file temp.cer $STOREINFO -keystore client.ts -noprompt
  
  echo "Creating a client certificate in keystore client.ks, exporting it"
  echo "to a temporary file, and then importing it to server truststore server.ts"
  echo ""
  ${JAVA_HOME}/bin/keytool -genkey -dname "$CLIENT_DN" $STOREINFO -keystore client.ks $KEYINFO
  ${JAVA_HOME}/bin/keytool -export -file temp.cer $STOREINFO -keystore client.ks
  ${JAVA_HOME}/bin/keytool -import -file temp.cer $STOREINFO -keystore server.ts -noprompt

  rm temp.cer
  echo ""
  echo "setup done for using self-signed certificates."
  exit 0
}

CASignedCerts()
{
  rm -f *.ks *.ts

  if [ ! -d ./cadir ] ; then
    echo "Setting up a CA directory structure ..."
    ${JSTK_HOME}/bin/certtool.sh setupca -password changeit -storetype $CASTORETYPE
    ${JSTK_HOME}/bin/certtool.sh exportca -password changeit
  fi

  echo "Creating a self-signed server certificate in keystore server.ks,"
  echo "generating a CSR, issuing a CA-signed certificate and importing this"
  echo "certificate to server.ks. Also, importing CA cert to server.ts."
  echo ""
  ${JAVA_HOME}/bin/keytool -genkey -dname "$SERVER_DN" $STOREINFO -keystore server.ks $KEYINFO
  ${JAVA_HOME}/bin/keytool -certreq -file temp.csr $STOREINFO -keystore server.ks
  ${JSTK_HOME}/bin/certtool.sh issue -csrfile temp.csr -cerfile server.cer -password changeit
  ${JAVA_HOME}/bin/keytool -import -file server.cer $STOREINFO -keystore server.ks -noprompt
  ${JAVA_HOME}/bin/keytool -import -file ca.cer $STOREINFO -keystore server.ts -noprompt
  

  echo "Creating a self-signed server certificate in keystore client.ks,"
  echo "generating a CSR, issuing a CA-signed certificate and importing this"
  echo "certificate to client.ks. Also, importing CA cert to client.ts."
  echo ""
  ${JAVA_HOME}/bin/keytool -genkey -dname "$CLIENT_DN" $STOREINFO -keystore client.ks $KEYINFO
  ${JAVA_HOME}/bin/keytool -certreq -file temp.csr $STOREINFO -keystore client.ks
  ${JSTK_HOME}/bin/certtool.sh issue -csrfile temp.csr -cerfile client.cer -password changeit
  ${JAVA_HOME}/bin/keytool -import -file client.cer $STOREINFO -keystore client.ks -noprompt
  ${JAVA_HOME}/bin/keytool -import -file ca.cer $STOREINFO -keystore client.ts -noprompt
  
  rm temp.csr
  echo ""
  echo "setup done for using CA-signed certificates."
  exit 0
}


SetServerEnv()
{
  echo "This option sets JSTK_OPTS for running \"ssltool server -inproto SSL ...\""
  echo ""
  export JSTK_OPTS="-Djavax.net.ssl.keyStore=server.ks -Djavax.net.ssl.keyStoreType=JCEKS -Djavax.net.ssl.keyStorePassword=changeit -Djavax.net.ssl.trustStore=server.ts -Djavax.net.ssl.trustStoreType=JCEKS"
  echo "setup done for keystore and truststore. JSTK_OPTS set to:"
  echo $JSTK_OPTS
}

SetClientEnv()
{
  echo "This option sets JSTK_OPTS for running \"ssltool client -outproto SSL ...\""
  echo ""
  export JSTK_OPTS="-Djavax.net.ssl.keyStore=client.ks -Djavax.net.ssl.keyStoreType=JCEKS -Djavax.net.ssl.keyStorePassword=changeit -Djavax.net.ssl.trustStore=client.ts -Djavax.net.ssl.trustStoreType=JCEKS"
  echo "setup done for keystore and truststore. JSTK_OPTS set to:"
  echo $JSTK_OPTS
}

if [ -z "$JSTK_HOME" ] ; then
  if [ -f license.jstk ] ; then
    JSTK_HOME=.
  elif [ -f ../license.jstk ] ; then
    JSTK_HOME=..
  else
    echo "Cannot determine JSTK HOME directory. Set JSTK_HOME."
    exit 1
  fi
else
  if [ ! -f "$JSTK_HOME"/license.jstk ]; then
    echo "No license.jstk file in $JSTK_HOME. Set JSTK_HOME properly."
    exit 1
  fi
fi

. "$JSTK_HOME"/bin/jstkenv.sh

SERVER_DN="CN=Server, OU=X, O=Y, L=Z, S=XY, C=YZ"
CLIENT_DN="CN=Client, OU=X, O=Y, L=Z, S=XY, C=YZ"
STOREINFO="-storepass changeit -storetype JCEKS -keypass changeit"
CASTORETYPE=JCEKS


[ -z $1 ] && printHelp
[ "$1" = "help" ] && printHelp
[ "$1" = "ss-certs" ] && SelfSignedCerts
[ "$1" = "cs-certs" ] && CASignedCerts
[ "$1" = "server-env" ] && SetServerEnv
[ "$1" = "client-env" ] && SetClientEnv
