package server;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Iterator;
import org.jstk.example.bank.BankIntf;
import org.jstk.example.bank.AccountIntf;

import common.RemoteIterator;

public class RemoteIteratorImpl extends UnicastRemoteObject implements RemoteIterator {
	private BankIntf bi;
	private Iterator itr;
	public RemoteIteratorImpl(BankIntf bi) throws RemoteException {
		this.bi = bi;
		itr = bi.accounts();
	}
    public RemoteIteratorImpl(BankIntf bi, int port,
    		java.rmi.server.RMIClientSocketFactory clientFactory,
    		java.rmi.server.RMIServerSocketFactory serverFactory) throws java.rmi.RemoteException {
		super(port, clientFactory, serverFactory);
		this.bi = bi;
		itr = bi.accounts();
    }
	public boolean hasNext() throws RemoteException {
		return itr.hasNext();
	}
	public Object next() throws RemoteException {
		return new RemoteAccountImpl((AccountIntf)itr.next());
	}
	public void remove() throws RemoteException {
		itr.remove();
	}
}
