/*
 * @(#) $Id: RemoteIteratorImpl.java,v 1.1.1.1 2003/10/05 18:39:08 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
package server;

import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Iterator;
import org.jstk.example.bank.BankIntf;
import org.jstk.example.bank.AccountIntf;

import common.RemoteIterator;

public class RemoteIteratorImpl extends UnicastRemoteObject implements RemoteIterator {
	private BankIntf bi;
	private Iterator itr;
	public RemoteIteratorImpl(BankIntf bi) throws RemoteException {
		this.bi = bi;
		itr = bi.accounts();
	}
	public boolean hasNext() throws RemoteException {
		return itr.hasNext();
	}
	public Object next() throws RemoteException {
		return new RemoteAccountImpl((AccountIntf)itr.next());
	}
	public void remove() throws RemoteException {
		itr.remove();
	}
}
