/*
 * @(#) $Id: RemoteBank.java,v 1.1.1.1 2003/10/05 18:39:08 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
package common;

import java.rmi.Remote;
import java.rmi.RemoteException;
import java.math.BigDecimal;
import org.jstk.example.bank.Exceptions;

public interface RemoteBank extends Remote {
	public RemoteAccount openAccount(BigDecimal initialDeposit) throws RemoteException;
	public void closeAccount(String acctNo) throws Exceptions.AccountNotFound,
			Exceptions.AccountClosed, RemoteException;
	public RemoteAccount getAccount(String acctNo) throws Exceptions.AccountNotFound, RemoteException;
	public RemoteIterator accounts() throws RemoteException;
}
