/*
 * @(#) $Id: GetVerifiedURL.java,v 1.1 2003/10/25 17:51:33 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net).
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the
 * root directory of the containing software.
 */
import java.net.URL;
import java.net.URLConnection;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSession;
import javax.net.ssl.HttpsURLConnection;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.IOException;

public class GetVerifiedURL {
	public static class CustomHostnameVerifier implements HostnameVerifier {
		private String hostname;
		public CustomHostnameVerifier(String hostname){
			this.hostname = hostname;
		}
		public boolean verify(String hostname, SSLSession sess){
			try {
				String peerHost = sess.getPeerHost();
				System.out.println("Expected hostname: " + hostname + ", Found: " + peerHost);
				System.out.print("Proceed(yes/no)?");
				System.out.flush();
				BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
				String response = br.readLine();
				return ("yes".equalsIgnoreCase(response.trim()));
			} catch (IOException ioe){
				return false;
			}
		}
	}
	public static void main(String[] args) throws Exception {
		if (args.length < 1){
			System.out.println("Usage:: java GetVerifiedURL <url>");
			return;
		}
		String urlString = args[0];
		URL url = new URL(urlString);
		String expectedHostname = url.getHost();
		CustomHostnameVerifier verifier = new CustomHostnameVerifier(expectedHostname);
		URLConnection con = url.openConnection();
		if (!(con instanceof HttpsURLConnection)){
			System.out.println(urlString + " is not a HTTPS URL.");
			return;
		}
		((HttpsURLConnection)con).setHostnameVerifier(verifier);

		BufferedReader br = new BufferedReader(new InputStreamReader(con.getInputStream()));
		String line = null;
		while ((line = br.readLine()) != null){
			System.out.println(line);
		}
	} // main()
}
