/*
 * @(#) $Id: GenerateKeyPair.java,v 1.1.1.1 2003/10/05 18:39:04 pankaj_kumar Exp $
 *
 * Copyright (c) 2002-03 by Pankaj Kumar (http://www.pankaj-k.net). 
 * All rights reserved.
 *
 * The license governing the use of this file can be found in the 
 * root directory of the containing software.
 */
import java.security.KeyPairGenerator;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.PrivateKey;
import java.security.Key;

public class GenerateKeyPair {
	private static String formatKey(Key key){
		StringBuffer sb = new StringBuffer();
		String algo = key.getAlgorithm();
		String fmt = key.getFormat();
		byte[] encoded = key.getEncoded();
		sb.append("Key[algorithm=" + algo + ", format=" + fmt + ", bytes=" + encoded.length + "]\n");
		if (fmt.equalsIgnoreCase("RAW")){
			sb.append("Key Material (in hex):: ");
			sb.append(Util.byteArray2Hex(key.getEncoded()));
		}
		return sb.toString();
	}
	public static void main(String[] unused) throws Exception {
		KeyPairGenerator kpg = KeyPairGenerator.getInstance("DSA");
		kpg.initialize(512); // 512 is the keysize.
		KeyPair kp = kpg.generateKeyPair();
		PublicKey pubk = kp.getPublic();
		PrivateKey prvk = kp.getPrivate();
		System.out.println("Generated Public Key:: " + formatKey(pubk));
		System.out.println("Generated Private Key:: " + formatKey(prvk));
	}
}